/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.blobs;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Journal;
import com.watabou.pixeldungeon.actors.blobs.Blob;
import com.watabou.pixeldungeon.effects.BlobEmitter;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.utils.Bundle;

public class Alchemy
extends Blob {
    protected int pos;

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        for (int i = 0; i < 1024; ++i) {
            if (this.cur[i] <= 0) continue;
            this.pos = i;
            break;
        }
    }

    @Override
    protected void evolve() {
        this.volume = this.off[this.pos] = this.cur[this.pos];
        if (Dungeon.visible[this.pos]) {
            Journal.add(Journal.Feature.ALCHEMY);
        }
    }

    @Override
    public void seed(int cell, int amount) {
        this.cur[this.pos] = 0;
        this.pos = cell;
        this.volume = this.cur[this.pos] = amount;
    }

    public static void transmute(int cell) {
        Item result;
        Heap heap = (Heap)Dungeon.level.heaps.get(cell);
        if (heap != null && (result = heap.transmute()) != null) {
            Dungeon.level.drop((Item)result, (int)cell).sprite.drop(cell);
        }
    }

    @Override
    public void use(BlobEmitter emitter) {
        super.use(emitter);
        emitter.start(Speck.factory(12), 0.4f, 0);
    }
}

