/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Statistics;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.blobs.Blob;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import java.util.Arrays;
import java.util.HashSet;

public abstract class Actor
implements Bundlable {
    public static final float TICK = 1.0f;
    private float time;
    private static final String TIME = "time";
    private static HashSet<Actor> all = new HashSet();
    private static Actor current;
    private static float now;
    private static Char[] chars;

    protected abstract boolean act();

    protected void spend(float time) {
        this.time += time;
    }

    protected void postpone(float time) {
        if (this.time < now + time) {
            this.time = now + time;
        }
    }

    protected float cooldown() {
        return this.time - now;
    }

    protected void diactivate() {
        this.time = Float.MAX_VALUE;
    }

    protected void onAdd() {
    }

    protected void onRemove() {
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        bundle.put(TIME, this.time);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        this.time = bundle.getFloat(TIME);
    }

    public static void clear() {
        now = 0.0f;
        Arrays.fill(chars, null);
        all.clear();
    }

    public static void fixTime() {
        if (Dungeon.hero != null && all.contains(Dungeon.hero)) {
            Statistics.duration += now;
        }
        float min = Float.MAX_VALUE;
        for (Actor a : all) {
            if (!(a.time < min)) continue;
            min = a.time;
        }
        for (Actor a : all) {
            a.time -= min;
        }
        now = 0.0f;
    }

    public static void init() {
        Actor.addDelayed(Dungeon.hero, -1.4E-45f);
        for (Mob mob : Dungeon.level.mobs) {
            Actor.add(mob);
        }
        for (Blob blob : Dungeon.level.blobs.values()) {
            Actor.add(blob);
        }
        current = null;
    }

    public static void occupyCell(Char ch) {
        Actor.chars[ch.pos] = ch;
    }

    public static void freeCell(int pos) {
        Actor.chars[pos] = null;
    }

    public void next() {
        if (current == this) {
            current = null;
        }
    }

    public static void process() {
        boolean doNext;
        if (current != null) {
            return;
        }
        do {
            now = Float.MAX_VALUE;
            current = null;
            Arrays.fill(chars, null);
            for (Actor actor : all) {
                Char ch;
                if (actor.time < now) {
                    now = actor.time;
                    current = actor;
                }
                if (!(actor instanceof Char)) continue;
                Actor.chars[ch.pos] = ch = (Char)actor;
            }
            if (current != null) {
                if (current instanceof Char && ((Char)Actor.current).sprite.isMoving) {
                    current = null;
                    break;
                }
                doNext = current.act();
                if (!doNext || Dungeon.hero.isAlive()) continue;
                doNext = false;
                current = null;
                continue;
            }
            doNext = false;
        } while (doNext);
    }

    public static void add(Actor actor) {
        Actor.add(actor, now);
    }

    public static void addDelayed(Actor actor, float delay) {
        Actor.add(actor, now + delay);
    }

    private static void add(Actor actor, float time) {
        if (all.contains(actor)) {
            return;
        }
        all.add(actor);
        actor.time += time;
        actor.onAdd();
        if (actor instanceof Char) {
            Char ch;
            Actor.chars[ch.pos] = ch = (Char)actor;
            for (Buff buff : ch.buffs()) {
                all.add(buff);
                buff.onAdd();
            }
        }
    }

    public static void remove(Actor actor) {
        if (actor != null) {
            all.remove(actor);
            actor.onRemove();
        }
    }

    public static Char findChar(int pos) {
        return chars[pos];
    }

    public static HashSet<Actor> all() {
        return all;
    }

    static {
        now = 0.0f;
        chars = new Char[1024];
    }
}

