/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon;

import com.watabou.noosa.Game;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Statistics;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.SystemTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.whitegem.pixeldungeon.LanguageFactory;

public enum Rankings {
    INSTANCE;

    public static final int TABLE_SIZE = 6;
    public static final String RANKINGS_FILE = "rankings.dat";
    public static final String DETAILS_FILE = "game_%d.dat";
    public ArrayList<Record> records;
    public int lastRecord;
    public int totalNumber;
    private static final String RECORDS = "records";
    private static final String LATEST = "latest";
    private static final String TOTAL = "total";
    private static final Comparator<Record> scoreComparator;

    public void submit(boolean win) {
        this.load();
        Record rec = new Record();
        rec.info = LanguageFactory.getTranslation(Dungeon.resultDescription);
        rec.win = win;
        rec.heroClass = Dungeon.hero.heroClass;
        rec.armorTier = Dungeon.hero.tier();
        rec.score = this.score(win);
        String gameFile = Utils.format(DETAILS_FILE, SystemTime.now);
        try {
            Dungeon.saveGame(gameFile);
            rec.gameFile = gameFile;
        }
        catch (IOException e) {
            rec.gameFile = "";
        }
        this.records.add(rec);
        Collections.sort(this.records, scoreComparator);
        this.lastRecord = this.records.indexOf(rec);
        int size = this.records.size();
        if (size > 6) {
            Record removedGame;
            if (this.lastRecord == size - 1) {
                removedGame = this.records.remove(size - 2);
                --this.lastRecord;
            } else {
                removedGame = this.records.remove(size - 1);
            }
            if (removedGame.gameFile.length() > 0) {
                Game.instance.deleteFile(removedGame.gameFile);
            }
        }
        ++this.totalNumber;
        Badges.validateGamesPlayed();
        this.save();
    }

    private int score(boolean win) {
        return (Statistics.goldCollected + Dungeon.hero.lvl * Dungeon.depth * 100) * (win ? 2 : 1);
    }

    public void save() {
        Bundle bundle = new Bundle();
        bundle.put(RECORDS, this.records);
        bundle.put(LATEST, this.lastRecord);
        bundle.put(TOTAL, this.totalNumber);
        try {
            OutputStream output = Game.instance.openFileOutput(RANKINGS_FILE);
            Bundle.write(bundle, output);
            output.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load() {
        if (this.records != null) {
            return;
        }
        this.records = new ArrayList();
        try {
            InputStream input = Game.instance.openFileInput(RANKINGS_FILE);
            Bundle bundle = Bundle.read(input);
            input.close();
            for (Bundlable record : bundle.getCollection(RECORDS)) {
                this.records.add((Record)record);
            }
            this.lastRecord = bundle.getInt(LATEST);
            this.totalNumber = bundle.getInt(TOTAL);
            if (this.totalNumber == 0) {
                this.totalNumber = this.records.size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        scoreComparator = new Comparator<Record>(){

            @Override
            public int compare(Record lhs, Record rhs) {
                return (int)Math.signum(rhs.score - lhs.score);
            }
        };
    }

    public static class Record
    implements Bundlable {
        private static final String REASON = "reason";
        private static final String WIN = "win";
        private static final String SCORE = "score";
        private static final String TIER = "tier";
        private static final String GAME = "gameFile";
        public String info;
        public boolean win;
        public HeroClass heroClass;
        public int armorTier;
        public int score;
        public String gameFile;

        @Override
        public void restoreFromBundle(Bundle bundle) {
            this.info = bundle.getString(REASON);
            this.win = bundle.getBoolean(WIN);
            this.score = bundle.getInt(SCORE);
            this.heroClass = HeroClass.restoreInBundle(bundle);
            this.armorTier = bundle.getInt(TIER);
            this.gameFile = bundle.getString(GAME);
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            bundle.put(REASON, this.info);
            bundle.put(WIN, this.win);
            bundle.put(SCORE, this.score);
            this.heroClass.storeInBundle(bundle);
            bundle.put(TIER, this.armorTier);
            bundle.put(GAME, this.gameFile);
        }
    }
}

