/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon;

import com.badlogic.gdx.Gdx;

public enum Preferences {
    INSTANCE;

    public static final String KEY_LANDSCAPE = "landscape";
    public static final String KEY_SCALE_UP = "scaleup";
    public static final String KEY_MUSIC = "music";
    public static final String KEY_SOUND_FX = "soundfx";
    public static final String KEY_ZOOM = "zoom";
    public static final String KEY_LAST_CLASS = "last_class";
    public static final String KEY_CHALLENGES = "challenges";
    public static final String KEY_DONATED = "donated";
    public static final String KEY_INTRO = "intro";
    public static final String KEY_BRIGHTNESS = "brightness";
    public static final String KEY_WINDOW_FULLSCREEN = "windowFullscreen";
    public static final String KEY_WINDOW_WIDTH = "windowWidth";
    public static final String KEY_WINDOW_HEIGHT = "windowHeight";
    public static final int DEFAULT_WINDOW_WIDTH = 480;
    public static final int DEFAULT_WINDOW_HEIGHT = 800;
    public static final String FILE_NAME = "pd-prefs";
    private com.badlogic.gdx.Preferences prefs;

    private com.badlogic.gdx.Preferences get() {
        if (this.prefs == null) {
            this.prefs = Gdx.app.getPreferences(FILE_NAME);
        }
        return this.prefs;
    }

    public int getInt(String key, int defValue) {
        return this.get().getInteger(key, defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.get().getBoolean(key, defValue);
    }

    public String getString(String key, String defValue) {
        return this.get().getString(key, defValue);
    }

    public void put(String key, int value) {
        this.get().putInteger(key, value);
        this.get().flush();
    }

    public void put(String key, boolean value) {
        this.get().putBoolean(key, value);
        this.get().flush();
    }

    public void put(String key, String value) {
        this.get().putString(key, value);
        this.get().flush();
    }
}

