/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Preferences;
import com.watabou.pixeldungeon.actors.blobs.Foliage;
import com.watabou.pixeldungeon.actors.blobs.WaterOfHealth;
import com.watabou.pixeldungeon.actors.buffs.Shadows;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.actors.mobs.npcs.MirrorImage;
import com.watabou.pixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.items.quest.DriedRose;
import com.watabou.pixeldungeon.items.rings.RingOfElements;
import com.watabou.pixeldungeon.items.rings.RingOfMending;
import com.watabou.pixeldungeon.items.rings.RingOfPower;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfPsionicBlast;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.watabou.pixeldungeon.items.wands.WandOfTelekinesis;
import com.watabou.pixeldungeon.items.weapon.missiles.Boomerang;
import com.watabou.pixeldungeon.plants.Dreamweed;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.scenes.TitleScene;
import com.watabou.utils.Bundle;
import com.watabou.utils.PDPlatformSupport;
import net.whitegem.pixeldungeon.LanguageUtil;
import net.whitegem.pixeldungeon.VersionUtil;

public class PixelDungeon
extends Game<GameAction> {
    public PixelDungeon(PDPlatformSupport<GameAction> platformSupport) {
        super(TitleScene.class, platformSupport);
        Game.version = platformSupport.getVersion();
        Bundle.addAlias(ScrollOfUpgrade.class, "com.watabou.pixeldungeon.items.scrolls.ScrollOfEnhancement");
        Bundle.addAlias(WaterOfHealth.class, "com.watabou.pixeldungeon.actors.blobs.Light");
        Bundle.addAlias(RingOfMending.class, "com.watabou.pixeldungeon.items.rings.RingOfRejuvenation");
        Bundle.addAlias(WandOfTelekinesis.class, "com.watabou.pixeldungeon.items.wands.WandOfTelekenesis");
        Bundle.addAlias(Foliage.class, "com.watabou.pixeldungeon.actors.blobs.Blooming");
        Bundle.addAlias(Shadows.class, "com.watabou.pixeldungeon.actors.buffs.Rejuvenation");
        Bundle.addAlias(ScrollOfPsionicBlast.class, "com.watabou.pixeldungeon.items.scrolls.ScrollOfNuclearBlast");
        Bundle.addAlias(Hero.class, "com.watabou.pixeldungeon.actors.Hero");
        Bundle.addAlias(Shopkeeper.class, "com.watabou.pixeldungeon.actors.mobs.Shopkeeper");
        Bundle.addAlias(DriedRose.class, "com.watabou.pixeldungeon.items.DriedRose");
        Bundle.addAlias(MirrorImage.class, "com.watabou.pixeldungeon.items.scrolls.ScrollOfMirrorImage.MirrorImage");
        Bundle.addAlias(RingOfElements.class, "com.watabou.pixeldungeon.items.rings.RingOfCleansing");
        Bundle.addAlias(RingOfElements.class, "com.watabou.pixeldungeon.items.rings.RingOfResistance");
        Bundle.addAlias(Boomerang.class, "com.watabou.pixeldungeon.items.weapon.missiles.RangersBoomerang");
        Bundle.addAlias(RingOfPower.class, "com.watabou.pixeldungeon.items.rings.RingOfEnergy");
        Bundle.addAlias(Dreamweed.class, "com.watabou.pixeldungeon.plants.Blindweed");
        Bundle.addAlias(Dreamweed.Seed.class, "com.watabou.pixeldungeon.plants.Blindweed$Seed");
    }

    @Override
    public void update() {
        super.update();
        VersionUtil.check();
    }

    @Override
    public void create() {
        super.create();
        LanguageUtil.setLanguage();
        boolean landscape = Gdx.graphics.getWidth() > Gdx.graphics.getHeight();
        Preferences prefs = Preferences.INSTANCE;
        if (prefs.getBoolean("landscape", false) != landscape) {
            PixelDungeon.landscape(!landscape);
        }
        PixelDungeon.fullscreen(prefs.getBoolean("windowFullscreen", false));
        Music.INSTANCE.enable(PixelDungeon.music());
        Sample.INSTANCE.enable(PixelDungeon.soundFx());
    }

    @Override
    public void resize(int width, int height) {
        boolean maximized;
        super.resize(width, height);
        Graphics.DisplayMode mode = Gdx.graphics.getDesktopDisplayMode();
        boolean bl = maximized = width >= mode.width || height >= mode.height;
        if (!maximized && !PixelDungeon.fullscreen()) {
            Preferences prefs = Preferences.INSTANCE;
            prefs.put("windowWidth", width);
            prefs.put("windowHeight", height);
        }
    }

    public static void landscape(boolean value) {
    }

    public static boolean landscape() {
        return width > height;
    }

    public static void fullscreen(boolean value) {
        Preferences prefs = Preferences.INSTANCE;
        if (value) {
            prefs.put("windowFullscreen", true);
            Gdx.graphics.setDisplayMode(Gdx.graphics.getDesktopDisplayMode().width, Gdx.graphics.getDesktopDisplayMode().height, true);
        } else {
            int w = prefs.getInt("windowWidth", 480);
            int h = prefs.getInt("windowHeight", 800);
            prefs.put("windowFullscreen", false);
            Gdx.graphics.setDisplayMode(w, h, false);
        }
    }

    public static boolean fullscreen() {
        return Gdx.graphics.isFullscreen();
    }

    public static void scaleUp(boolean value) {
        Preferences.INSTANCE.put("scaleup", value);
        PixelDungeon.switchScene(TitleScene.class);
    }

    public static boolean scaleUp() {
        return Preferences.INSTANCE.getBoolean("scaleup", true);
    }

    public static void zoom(int value) {
        Preferences.INSTANCE.put("zoom", value);
    }

    public static int zoom() {
        return Preferences.INSTANCE.getInt("zoom", 0);
    }

    public static void music(boolean value) {
        Music.INSTANCE.enable(value);
        Preferences.INSTANCE.put("music", value);
    }

    public static boolean music() {
        return Preferences.INSTANCE.getBoolean("music", true);
    }

    public static void soundFx(boolean value) {
        Sample.INSTANCE.enable(value);
        Preferences.INSTANCE.put("soundfx", value);
    }

    public static boolean soundFx() {
        return Preferences.INSTANCE.getBoolean("soundfx", true);
    }

    public static void brightness(boolean value) {
        Preferences.INSTANCE.put("brightness", value);
        if (PixelDungeon.scene() instanceof GameScene) {
            ((GameScene)PixelDungeon.scene()).brightness(value);
        }
    }

    public static boolean brightness() {
        return Preferences.INSTANCE.getBoolean("brightness", false);
    }

    public static void donated(String value) {
        Preferences.INSTANCE.put("donated", value);
    }

    public static String donated() {
        return Preferences.INSTANCE.getString("donated", "");
    }

    public static void lastClass(int value) {
        Preferences.INSTANCE.put("last_class", value);
    }

    public static int lastClass() {
        return Preferences.INSTANCE.getInt("last_class", 0);
    }

    public static void challenges(int value) {
        Preferences.INSTANCE.put("challenges", value);
    }

    public static int challenges() {
        return Preferences.INSTANCE.getInt("challenges", 0);
    }

    public static void intro(boolean value) {
        Preferences.INSTANCE.put("intro", value);
    }

    public static boolean intro() {
        return Preferences.INSTANCE.getBoolean("intro", true);
    }

    public static void switchNoFade(Class<? extends PixelScene> c) {
        PixelScene.noFade = true;
        PixelDungeon.switchScene(c);
    }

    public static void reportException(Exception e) {
        Gdx.app.error("PD", e.getMessage(), e);
    }
}

