/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.watabou.gdx.GdxTexture;
import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.noosa.Image;
import com.watabou.pixeldungeon.scenes.GameScene;
import java.util.Arrays;

public class FogOfWar
extends Image {
    private static final int VISIBLE = 0;
    private static final int VISITED = -871296751;
    private static final int MAPPED = -867950063;
    private static final int INVISIBLE = -16777216;
    private int[] pixels;
    private int pWidth;
    private int pHeight;
    private int width2;
    private int height2;

    public FogOfWar(int mapWidth, int mapHeight) {
        this.pWidth = mapWidth + 1;
        this.pHeight = mapHeight + 1;
        this.width2 = 1;
        while (this.width2 < this.pWidth) {
            this.width2 <<= 1;
        }
        this.height2 = 1;
        while (this.height2 < this.pHeight) {
            this.height2 <<= 1;
        }
        float size = 16.0f;
        this.width = (float)this.width2 * size;
        this.height = (float)this.height2 * size;
        this.texture(new FogTexture());
        this.scale.set(16.0f, 16.0f);
        this.x = this.y = -size / 2.0f;
    }

    public void updateVisibility(boolean[] visible, boolean[] visited, boolean[] mapped) {
        if (this.pixels == null) {
            this.pixels = new int[this.width2 * this.height2];
            Arrays.fill(this.pixels, -16777216);
        }
        for (int i = 1; i < this.pHeight - 1; ++i) {
            int pos = (this.pWidth - 1) * i;
            for (int j = 1; j < this.pWidth - 1; ++j) {
                int c = -16777216;
                if (visible[++pos] && visible[pos - (this.pWidth - 1)] && visible[pos - 1] && visible[pos - (this.pWidth - 1) - 1]) {
                    c = 0;
                } else if (visited[pos] && visited[pos - (this.pWidth - 1)] && visited[pos - 1] && visited[pos - (this.pWidth - 1) - 1]) {
                    c = -871296751;
                } else if (mapped[pos] && mapped[pos - (this.pWidth - 1)] && mapped[pos - 1] && mapped[pos - (this.pWidth - 1) - 1]) {
                    c = -867950063;
                }
                this.pixels[i * this.width2 + j] = c;
            }
        }
        this.texture.pixels(this.width2, this.height2, this.pixels);
    }

    private class FogTexture
    extends SmartTexture {
        public FogTexture() {
            super(new GdxTexture(FogOfWar.this.width2, FogOfWar.this.height2, Pixmap.Format.RGBA8888));
            this.filter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            TextureCache.add(FogOfWar.class, this);
        }

        @Override
        public void reload() {
            super.reload();
            GameScene.afterObserve();
        }
    }
}

