/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon;

import com.watabou.noosa.Image;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.Tilemap;
import com.watabou.noosa.tweeners.AlphaTweener;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.utils.Point;
import com.watabou.utils.PointF;

public class DungeonTilemap
extends Tilemap {
    public static final int SIZE = 16;
    private static DungeonTilemap instance;

    public DungeonTilemap() {
        super(Dungeon.level.tilesTex(), new TextureFilm(Dungeon.level.tilesTex(), 16, 16));
        this.map(Dungeon.level.map, 32);
        instance = this;
    }

    public int screenToTile(int x, int y) {
        Point p = this.camera().screenToCamera(x, y).offset(this.point().negate()).invScale(16.0f).floor();
        return p.x >= 0 && p.x < 32 && p.y >= 0 && p.y < 32 ? p.x + p.y * 32 : -1;
    }

    @Override
    public boolean overlapsPoint(float x, float y) {
        return true;
    }

    public void discover(int pos, int oldValue) {
        final Image tile = DungeonTilemap.tile(oldValue);
        tile.point(DungeonTilemap.tileToWorld(pos));
        tile.gm = tile.bm = this.rm;
        tile.rm = tile.bm;
        tile.ga = tile.ba = this.ra;
        tile.ra = tile.ba;
        this.parent.add(tile);
        this.parent.add(new AlphaTweener(tile, 0.0f, 0.6f){

            @Override
            protected void onComplete() {
                tile.killAndErase();
                this.killAndErase();
            }
        });
    }

    public static PointF tileToWorld(int pos) {
        return new PointF(pos % 32, pos / 32).scale(16.0f);
    }

    public static PointF tileCenterToWorld(int pos) {
        return new PointF(((float)(pos % 32) + 0.5f) * 16.0f, ((float)(pos / 32) + 0.5f) * 16.0f);
    }

    public static Point tileToPoint(int pos) {
        return new Point(pos % 32, pos / 32);
    }

    public static int pointToTile(Point point) {
        return point.y * 32 + point.x;
    }

    public static Image tile(int index) {
        Image img = new Image(DungeonTilemap.instance.texture);
        img.frame(DungeonTilemap.instance.tileset.get(index));
        return img;
    }

    @Override
    public boolean overlapsScreenPoint(int x, int y) {
        return true;
    }
}

