/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon;

import com.watabou.noosa.Game;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.items.Gold;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.rings.Ring;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Bones {
    private static final String BONES_FILE = "bones.dat";
    private static final String LEVEL = "level";
    private static final String ITEM = "item";
    private static int depth = -1;
    private static Item item;

    public static void leave() {
        item = null;
        switch (Random.Int(4)) {
            case 0: {
                item = Dungeon.hero.belongings.weapon;
                break;
            }
            case 1: {
                item = Dungeon.hero.belongings.armor;
                break;
            }
            case 2: {
                item = Dungeon.hero.belongings.ring1;
                break;
            }
            case 3: {
                item = Dungeon.hero.belongings.ring2;
            }
        }
        if (item == null) {
            item = Dungeon.gold > 0 ? new Gold(Random.IntRange(1, Dungeon.gold)) : new Gold(1);
        }
        depth = Dungeon.depth;
        Bundle bundle = new Bundle();
        bundle.put(LEVEL, depth);
        bundle.put(ITEM, item);
        try {
            OutputStream output = Game.instance.openFileOutput(BONES_FILE);
            Bundle.write(bundle, output);
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Item get() {
        if (depth == -1) {
            try {
                InputStream input = Game.instance.openFileInput(BONES_FILE);
                Bundle bundle = Bundle.read(input);
                input.close();
                depth = bundle.getInt(LEVEL);
                item = (Item)bundle.get(ITEM);
                return Bones.get();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (depth == Dungeon.depth) {
            Game.instance.deleteFile(BONES_FILE);
            depth = 0;
            if (!Bones.item.stackable) {
                Bones.item.cursed = true;
                Bones.item.cursedKnown = true;
                if (item.isUpgradable()) {
                    int lvl = (Dungeon.depth - 1) * 3 / 5 + 1;
                    if (lvl < Bones.item.level) {
                        item.degrade(Bones.item.level - lvl);
                    }
                    Bones.item.levelKnown = false;
                }
            }
            if (item instanceof Ring) {
                ((Ring)item).syncGem();
            }
            return item;
        }
        return null;
    }
}

