/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pd.desktop;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglPreferences;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.watabou.input.NoosaInputProcessor;
import com.watabou.pd.desktop.DesktopInputProcessor;
import com.watabou.pixeldungeon.PixelDungeon;
import com.watabou.utils.PDPlatformSupport;

public class DesktopLauncher {
    public static void main(String[] arg) {
        boolean isFullscreen;
        String version = DesktopLauncher.class.getPackage().getSpecificationVersion();
        if (version == null) {
            version = "???";
        }
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        if (SharedLibraryLoader.isMac) {
            config.preferencesDirectory = "Library/Application Support/Pixel Dungeon/";
        } else if (SharedLibraryLoader.isLinux) {
            config.preferencesDirectory = ".watabou/pixel-dungeon/";
        } else if (SharedLibraryLoader.isWindows) {
            config.preferencesDirectory = "Saved Games/Pixel Dungeon/";
        }
        LwjglPreferences prefs = new LwjglPreferences("pd-prefs", config.preferencesDirectory);
        config.fullscreen = isFullscreen = prefs.getBoolean("windowFullscreen", false);
        if (!isFullscreen) {
            config.width = prefs.getInteger("windowWidth", 480);
            config.height = prefs.getInteger("windowHeight", 800);
        }
        config.addIcon("ic_launcher_128.png", Files.FileType.Internal);
        config.addIcon("ic_launcher_32.png", Files.FileType.Internal);
        config.addIcon("ic_launcher_16.png", Files.FileType.Internal);
        config.title = "Pixel Dungeon";
        new LwjglApplication((ApplicationListener)new PixelDungeon(new DesktopSupport(version, config.preferencesDirectory, (NoosaInputProcessor)new DesktopInputProcessor())), config);
    }

    private static class DesktopSupport
    extends PDPlatformSupport {
        public DesktopSupport(String version, String basePath, NoosaInputProcessor inputProcessor) {
            super(version, basePath, inputProcessor);
        }

        @Override
        public boolean isFullscreenEnabled() {
            return !SharedLibraryLoader.isMac;
        }
    }
}

