/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pd.desktop;

import com.badlogic.gdx.utils.IntMap;
import com.watabou.input.NoosaInputProcessor;
import com.watabou.pixeldungeon.Preferences;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.input.PDInputProcessor;
import java.util.HashMap;
import java.util.Map;

public class DesktopInputProcessor
extends PDInputProcessor {
    public static final String GAMEACTION_PREFIX1 = "ACT1_";
    public static final String GAMEACTION_PREFIX2 = "ACT2_";
    private final Map<Integer, PDInputProcessor.GameActionWrapper> keyMappings = new HashMap<Integer, PDInputProcessor.GameActionWrapper>();
    private static final HashMap<GameAction, KeyPair> DEFAULTS = new HashMap();

    @Override
    public void init() {
        super.init();
        if (Preferences.INSTANCE.getInt(DesktopInputProcessor.getPrefKey(GameAction.BACK, true), 0) == 0) {
            this.resetKeyMappings();
        }
        for (GameAction action : GameAction.values()) {
            this.loadKeyMapping(action);
        }
    }

    private void loadKeyMapping(GameAction action) {
        int mapping2;
        int mapping1 = Preferences.INSTANCE.getInt(DesktopInputProcessor.getPrefKey(action, true), -1);
        if (mapping1 > 0) {
            this.keyMappings.put(mapping1, new PDInputProcessor.GameActionWrapper(action, true));
        }
        if ((mapping2 = Preferences.INSTANCE.getInt(DesktopInputProcessor.getPrefKey(action, false), -1)) > 0) {
            this.keyMappings.put(mapping2, new PDInputProcessor.GameActionWrapper(action, false));
        }
    }

    @Override
    public Map<Integer, PDInputProcessor.GameActionWrapper> getKeyMappings() {
        return this.keyMappings;
    }

    @Override
    public void resetKeyMappings() {
        this.keyMappings.clear();
        for (GameAction action : GameAction.values()) {
            KeyPair pair = DEFAULTS.get((Object)action);
            if (pair != null) {
                this.setKeyMapping(action, pair.code1, pair.code2);
            } else {
                pair = new KeyPair();
            }
            Preferences.INSTANCE.put(DesktopInputProcessor.getPrefKey(action, true), pair.code1);
            Preferences.INSTANCE.put(DesktopInputProcessor.getPrefKey(action, false), pair.code2);
        }
    }

    @Override
    public PDInputProcessor.GameActionWrapper setKeyMapping(GameAction action, boolean defaultKey, int code) {
        PDInputProcessor.GameActionWrapper existingMapping = this.keyMappings.get(code);
        this.keyMappings.put(code, new PDInputProcessor.GameActionWrapper(action, defaultKey));
        Preferences.INSTANCE.put(DesktopInputProcessor.getPrefKey(action, defaultKey), code);
        if (existingMapping != null && (existingMapping.gameAction != action || existingMapping.defaultKey != defaultKey)) {
            Preferences.INSTANCE.put(DesktopInputProcessor.getPrefKey(existingMapping.gameAction, existingMapping.defaultKey), -1);
            return existingMapping;
        }
        return null;
    }

    public void setKeyMapping(GameAction action, int code1, int code2) {
        if (code1 > 0) {
            this.keyMappings.put(code1, new PDInputProcessor.GameActionWrapper(action, true));
        } else {
            this.keyMappings.remove(code1);
        }
        if (code2 > 0) {
            this.keyMappings.put(code2, new PDInputProcessor.GameActionWrapper(action, false));
        } else {
            this.keyMappings.remove(code2);
        }
    }

    public void setKeyMapping(GameAction action, int code) {
        this.setKeyMapping(action, code, 0);
    }

    @Override
    public PDInputProcessor.GameActionWrapper removeKeyMapping(GameAction action, boolean defaultKey, int code) {
        PDInputProcessor.GameActionWrapper result = this.keyMappings.remove(code);
        Preferences.INSTANCE.put(DesktopInputProcessor.getPrefKey(action, defaultKey), -1);
        return result;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        NoosaInputProcessor.Touch touch = new NoosaInputProcessor.Touch(screenX, screenY);
        this.pointers.put(button, touch);
        this.eventTouch.dispatch(touch);
        return true;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        NoosaInputProcessor.Touch touch = (NoosaInputProcessor.Touch)this.pointers.remove(button);
        if (touch != null) {
            this.eventTouch.dispatch(touch.up());
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        for (IntMap.Entry entry : this.pointers) {
            ((NoosaInputProcessor.Touch)entry.value).update(screenX, screenY);
        }
        this.eventTouch.dispatch(null);
        return true;
    }

    @Override
    protected GameAction keycodeToGameAction(int keycode) {
        GameAction defaultResult = super.keycodeToGameAction(keycode);
        if (defaultResult != null) {
            return defaultResult;
        }
        if (this.keyMappings.containsKey(keycode)) {
            return this.keyMappings.get((Object)Integer.valueOf((int)keycode)).gameAction;
        }
        return GameAction.UNKNOWN;
    }

    private static String getPrefKey(GameAction action, boolean defaultKey) {
        return (defaultKey ? GAMEACTION_PREFIX1 : GAMEACTION_PREFIX2) + (Object)((Object)action);
    }

    private static void putToPrefs(GameAction action, boolean defaultKey, boolean code) {
        Preferences.INSTANCE.put(DesktopInputProcessor.getPrefKey(action, defaultKey), code);
    }

    static {
        DEFAULTS.put(GameAction.HERO_INFO, new KeyPair(36));
        DEFAULTS.put(GameAction.CATALOGUS, new KeyPair(31));
        DEFAULTS.put(GameAction.JOURNAL, new KeyPair(38));
        DEFAULTS.put(GameAction.REST, new KeyPair(62));
        DEFAULTS.put(GameAction.SEARCH, new KeyPair(47));
        DEFAULTS.put(GameAction.CELL_INFO, new KeyPair(50));
        DEFAULTS.put(GameAction.RESUME, new KeyPair(46));
        DEFAULTS.put(GameAction.BACKPACK, new KeyPair(37));
        DEFAULTS.put(GameAction.QUICKSLOT, new KeyPair(45));
        DEFAULTS.put(GameAction.TAG_ATTACK, new KeyPair(29));
        DEFAULTS.put(GameAction.TAG_DANGER, new KeyPair(61));
        DEFAULTS.put(GameAction.ZOOM_IN, new KeyPair(81, 70));
        DEFAULTS.put(GameAction.ZOOM_OUT, new KeyPair(69));
        DEFAULTS.put(GameAction.ZOOM_DEFAULT, new KeyPair(76));
        DEFAULTS.put(GameAction.MOVE_UP, new KeyPair(19, 152));
        DEFAULTS.put(GameAction.MOVE_DOWN, new KeyPair(20, 146));
        DEFAULTS.put(GameAction.MOVE_LEFT, new KeyPair(21, 148));
        DEFAULTS.put(GameAction.MOVE_RIGHT, new KeyPair(22, 150));
        DEFAULTS.put(GameAction.MOVE_TOP_LEFT, new KeyPair(151));
        DEFAULTS.put(GameAction.MOVE_TOP_RIGHT, new KeyPair(153));
        DEFAULTS.put(GameAction.MOVE_BOTTOM_LEFT, new KeyPair(145));
        DEFAULTS.put(GameAction.MOVE_BOTTOM_RIGHT, new KeyPair(147));
        DEFAULTS.put(GameAction.OPERATE, new KeyPair(66));
    }

    private static class KeyPair {
        public int code1;
        public int code2;

        public KeyPair(int code1, int code2) {
            this.code1 = code1;
            this.code2 = code2;
        }

        public KeyPair(int code) {
            this(code, -1);
        }

        public KeyPair() {
            this.code1 = -1;
            this.code2 = -1;
        }
    }
}

