/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa.ui;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.Game;
import com.watabou.noosa.TouchArea;
import com.watabou.noosa.ui.Component;

public class Button<T>
extends Component {
    public static float longClick = 1.0f;
    protected TouchArea hotArea;
    protected boolean pressed;
    protected float pressTime;
    protected boolean processed;
    public T hotKey = null;

    @Override
    protected void createChildren() {
        this.hotArea = new TouchArea<T>(0.0f, 0.0f, 0.0f, 0.0f){

            @Override
            protected void onTouchDown(NoosaInputProcessor.Touch touch) {
                Button.this.pressed = true;
                Button.this.pressTime = 0.0f;
                Button.this.processed = false;
                Button.this.onTouchDown();
            }

            @Override
            protected void onTouchUp(NoosaInputProcessor.Touch touch) {
                Button.this.pressed = false;
                Button.this.onTouchUp();
            }

            @Override
            protected void onClick(NoosaInputProcessor.Touch touch) {
                if (!(Button.this.processed || NoosaInputProcessor.modifier && Button.this.onLongClick())) {
                    Button.this.onClick();
                }
            }

            @Override
            public boolean onKeyDown(NoosaInputProcessor.Key<T> key) {
                return Button.this.onKeyDown(key);
            }

            @Override
            public boolean onKeyUp(NoosaInputProcessor.Key<T> key) {
                return Button.this.onKeyUp(key);
            }
        };
        this.add(this.hotArea);
    }

    @Override
    public void update() {
        super.update();
        this.hotArea.active = this.visible;
        if (this.pressed) {
            float f;
            this.pressTime += Game.elapsed;
            if (f >= longClick) {
                this.pressed = false;
                if (this.onLongClick()) {
                    this.hotArea.reset();
                    this.processed = true;
                    this.onTouchUp();
                    Game.vibrate(50);
                }
            }
        }
    }

    protected void onTouchDown() {
    }

    protected void onTouchUp() {
    }

    protected void onClick() {
    }

    protected boolean onLongClick() {
        return false;
    }

    protected boolean onKeyDown(NoosaInputProcessor.Key<T> key) {
        return false;
    }

    protected boolean onKeyUp(NoosaInputProcessor.Key<T> key) {
        if (this.active && this.hotKey != null && key.action.equals(this.hotKey)) {
            if (NoosaInputProcessor.modifier) {
                return this.onLongClick();
            }
            this.onClick();
            return true;
        }
        return false;
    }

    @Override
    protected void layout() {
        this.hotArea.x = this.x;
        this.hotArea.y = this.y;
        this.hotArea.width = this.width;
        this.hotArea.height = this.height;
    }
}

