/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa.particles;

import com.badlogic.gdx.Gdx;
import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.Visual;
import com.watabou.utils.PointF;
import com.watabou.utils.Random;

public class Emitter
extends Group {
    protected boolean lightMode = false;
    public float x;
    public float y;
    public float width;
    public float height;
    protected Visual target;
    protected float interval;
    protected int quantity;
    public boolean on = false;
    public boolean autoKill = true;
    protected int count;
    protected float time;
    protected Factory factory;

    public void pos(float x, float y) {
        this.pos(x, y, 0.0f, 0.0f);
    }

    public void pos(PointF p) {
        this.pos(p.x, p.y, 0.0f, 0.0f);
    }

    public void pos(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.target = null;
    }

    public void pos(Visual target) {
        this.target = target;
    }

    public void burst(Factory factory, int quantity) {
        this.start(factory, 0.0f, quantity);
    }

    public void pour(Factory factory, float interval) {
        this.start(factory, interval, 0);
    }

    public void start(Factory factory, float interval, int quantity) {
        this.factory = factory;
        this.lightMode = factory.lightMode();
        this.interval = interval;
        this.quantity = quantity;
        this.count = 0;
        this.time = Random.Float(interval);
        this.on = true;
    }

    @Override
    public void update() {
        if (this.on) {
            this.time += Game.elapsed;
            while (this.time > this.interval) {
                this.time -= this.interval;
                this.emit(this.count);
                if (this.quantity <= 0 || ++this.count < this.quantity) continue;
                this.on = false;
                break;
            }
        } else if (this.autoKill && this.countLiving() == 0) {
            this.kill();
        }
        super.update();
    }

    protected void emit(int index) {
        if (this.target == null) {
            this.factory.emit(this, index, this.x + Random.Float(this.width), this.y + Random.Float(this.height));
        } else {
            this.factory.emit(this, index, this.target.x + Random.Float(this.target.width), this.target.y + Random.Float(this.target.height));
        }
    }

    @Override
    public void draw() {
        if (this.lightMode) {
            Gdx.gl.glBlendFunc(770, 1);
            super.draw();
            Gdx.gl.glBlendFunc(770, 771);
        } else {
            super.draw();
        }
    }

    public static abstract class Factory {
        public abstract void emit(Emitter var1, int var2, float var3, float var4);

        public boolean lightMode() {
            return false;
        }
    }
}

