/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa.audio;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import java.util.HashMap;

public enum Sample {
    INSTANCE;

    protected HashMap<Object, Sound> ids = new HashMap();
    private boolean enabled = true;

    public void reset() {
        for (Sound sound : this.ids.values()) {
            sound.dispose();
        }
        this.ids.clear();
    }

    public void pause() {
        for (Sound sound : this.ids.values()) {
            sound.pause();
        }
    }

    public void resume() {
        for (Sound sound : this.ids.values()) {
            sound.resume();
        }
    }

    public void load(String ... assets) {
        for (int i = 0; i < assets.length; ++i) {
            String asset = assets[i];
            if (this.ids.containsKey(asset)) continue;
            this.ids.put(asset, Gdx.audio.newSound(Gdx.files.internal(asset)));
        }
    }

    public void unload(Object src) {
        if (this.ids.containsKey(src)) {
            this.ids.get(src).dispose();
            this.ids.remove(src);
        }
    }

    public long play(Object id) {
        return this.play(id, 1.0f, 1.0f, 1.0f);
    }

    public long play(Object id, float volume) {
        return this.play(id, volume, volume, 1.0f);
    }

    public long play(Object id, float leftVolume, float rightVolume, float rate) {
        if (this.enabled && this.ids.containsKey(id)) {
            Sound sound = this.ids.get(id);
            return sound.play(leftVolume, rate, 0.0f);
        }
        return -1L;
    }

    public void enable(boolean value) {
        this.enabled = value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

