/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa.audio;

import com.badlogic.gdx.Gdx;

public enum Music {
    INSTANCE;

    private com.badlogic.gdx.audio.Music player;
    private String lastPlayed;
    private boolean lastLooping;
    private boolean enabled = true;

    public void play(String assetName, boolean looping) {
        if (this.isPlaying() && this.lastPlayed.equals(assetName)) {
            return;
        }
        this.stop();
        this.lastPlayed = assetName;
        this.lastLooping = looping;
        if (!this.enabled || assetName == null) {
            return;
        }
        this.player = Gdx.audio.newMusic(Gdx.files.internal(assetName));
        this.player.setLooping(looping);
        this.player.play();
    }

    public void mute() {
        this.lastPlayed = null;
        this.stop();
    }

    public void pause() {
        if (this.player != null) {
            this.player.pause();
        }
    }

    public void resume() {
        if (this.player != null) {
            this.player.play();
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
            this.player.dispose();
            this.player = null;
        }
    }

    public void volume(float value) {
        if (this.player != null) {
            this.player.setVolume(value);
        }
    }

    public boolean isPlaying() {
        return this.player != null && this.player.isPlaying();
    }

    public void enable(boolean value) {
        this.enabled = value;
        if (this.isPlaying() && !value) {
            this.stop();
        } else if (!this.isPlaying() && value) {
            this.play(this.lastPlayed, this.lastLooping);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

