/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.Game;
import com.watabou.noosa.Visual;
import com.watabou.utils.Signal;

public class TouchArea<T>
extends Visual
implements Signal.Listener<NoosaInputProcessor.Touch> {
    public final Visual target;
    protected NoosaInputProcessor.Touch touch = null;
    private Signal.Listener<NoosaInputProcessor.Key<T>> keyListener = new Signal.Listener<NoosaInputProcessor.Key<T>>(){

        @Override
        public void onSignal(NoosaInputProcessor.Key<T> key) {
            boolean handled = key.pressed ? TouchArea.this.onKeyDown(key) : TouchArea.this.onKeyUp(key);
            if (handled) {
                Game.instance.getInputProcessor().cancelKeyEvent();
            }
        }
    };
    private Signal.Listener<NoosaInputProcessor.PDMouseEvent> mouseListener = new Signal.Listener<NoosaInputProcessor.PDMouseEvent>(){

        @Override
        public void onSignal(NoosaInputProcessor.PDMouseEvent event) {
            boolean handled = TouchArea.this.onMouseScroll(event.scroll);
            if (handled) {
                Game.instance.getInputProcessor().cancelMouseEvent();
            }
        }
    };

    public boolean onMouseScroll(int scroll) {
        return false;
    }

    public boolean onKeyDown(NoosaInputProcessor.Key<T> key) {
        return false;
    }

    public boolean onKeyUp(NoosaInputProcessor.Key<T> key) {
        return false;
    }

    public TouchArea(Visual target) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.target = target;
        this.setupListeners();
    }

    public TouchArea(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.target = this;
        this.visible = false;
        this.setupListeners();
    }

    private void setupListeners() {
        NoosaInputProcessor ip = Game.instance.getInputProcessor();
        ip.addTouchListener(this);
        ip.addKeyListener(this.keyListener);
        ip.addMouseListener(this.mouseListener);
    }

    @Override
    public void onSignal(NoosaInputProcessor.Touch touch) {
        boolean hit;
        if (!this.isActive()) {
            return;
        }
        boolean bl = hit = touch != null && this.target.overlapsScreenPoint((int)touch.start.x, (int)touch.start.y);
        if (hit) {
            Game.instance.getInputProcessor().cancelTouchEvent();
            if (touch.down) {
                if (this.touch == null) {
                    this.touch = touch;
                }
                this.onTouchDown(touch);
            } else {
                this.onTouchUp(touch);
                if (this.touch == touch) {
                    this.touch = null;
                    this.onClick(touch);
                }
            }
        } else if (touch == null && this.touch != null) {
            this.onDrag(this.touch);
        } else if (this.touch != null && touch != null && !touch.down) {
            this.onTouchUp(touch);
            this.touch = null;
        }
    }

    protected void onTouchDown(NoosaInputProcessor.Touch touch) {
    }

    protected void onTouchUp(NoosaInputProcessor.Touch touch) {
    }

    protected void onClick(NoosaInputProcessor.Touch touch) {
    }

    protected void onDrag(NoosaInputProcessor.Touch touch) {
    }

    public void reset() {
        this.touch = null;
    }

    @Override
    public void destroy() {
        NoosaInputProcessor ip = Game.instance.getInputProcessor();
        ip.removeMouseListener(this.mouseListener);
        ip.removeKeyListener(this.keyListener);
        ip.removeTouchListener(this);
        super.destroy();
    }
}

