/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.glwrap.Quad;
import com.watabou.noosa.NoosaScript;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.Visual;
import com.watabou.utils.Rect;
import com.watabou.utils.RectF;
import java.nio.FloatBuffer;

public class Tilemap
extends Visual {
    protected SmartTexture texture;
    protected TextureFilm tileset;
    protected int[] data;
    protected int mapWidth;
    protected int mapHeight;
    protected int size;
    private float cellW;
    private float cellH;
    protected float[] vertices;
    protected FloatBuffer quads;
    public Rect updated;

    public Tilemap(Object tx, TextureFilm tileset) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.texture = TextureCache.get(tx);
        this.tileset = tileset;
        RectF r = tileset.get(0);
        this.cellW = tileset.width(r);
        this.cellH = tileset.height(r);
        this.vertices = new float[16];
        this.updated = new Rect();
    }

    public void map(int[] data, int cols) {
        this.data = data;
        this.mapWidth = cols;
        this.mapHeight = data.length / cols;
        this.size = this.mapWidth * this.mapHeight;
        this.width = this.cellW * (float)this.mapWidth;
        this.height = this.cellH * (float)this.mapHeight;
        this.quads = Quad.createSet(this.size);
        this.updated.set(0, 0, this.mapWidth, this.mapHeight);
    }

    protected void updateVertices() {
        float y1 = this.cellH * (float)this.updated.top;
        float y2 = y1 + this.cellH;
        for (int i = this.updated.top; i < this.updated.bottom; ++i) {
            float x1 = this.cellW * (float)this.updated.left;
            float x2 = x1 + this.cellW;
            int pos = i * this.mapWidth + this.updated.left;
            this.quads.position(16 * pos);
            for (int j = this.updated.left; j < this.updated.right; ++j) {
                RectF uv = this.tileset.get(this.data[pos++]);
                this.vertices[0] = x1;
                this.vertices[1] = y1;
                this.vertices[2] = uv.left;
                this.vertices[3] = uv.top;
                this.vertices[4] = x2;
                this.vertices[5] = y1;
                this.vertices[6] = uv.right;
                this.vertices[7] = uv.top;
                this.vertices[8] = x2;
                this.vertices[9] = y2;
                this.vertices[10] = uv.right;
                this.vertices[11] = uv.bottom;
                this.vertices[12] = x1;
                this.vertices[13] = y2;
                this.vertices[14] = uv.left;
                this.vertices[15] = uv.bottom;
                this.quads.put(this.vertices);
                x1 = x2;
                x2 += this.cellW;
            }
            y1 = y2;
            y2 += this.cellH;
        }
        this.updated.setEmpty();
    }

    @Override
    public void draw() {
        super.draw();
        NoosaScript script = NoosaScript.get();
        this.texture.bind();
        script.uModel.valueM4(this.matrix);
        script.lighting(this.rm, this.gm, this.bm, this.am, this.ra, this.ga, this.ba, this.aa);
        if (!this.updated.isEmpty()) {
            this.updateVertices();
        }
        script.camera(this.camera);
        script.drawQuadSet(this.quads, this.size);
    }
}

