/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.badlogic.gdx.Gdx;
import com.watabou.glscripts.Script;
import com.watabou.glwrap.Attribute;
import com.watabou.glwrap.Quad;
import com.watabou.glwrap.Uniform;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class NoosaScript
extends Script {
    public Uniform uCamera;
    public Uniform uModel;
    public Uniform uTex;
    public Uniform uColorM;
    public Uniform uColorA;
    public Attribute aXY;
    public Attribute aUV;
    private Camera lastCamera;
    private static final String SHADER = "uniform mat4 uCamera;uniform mat4 uModel;attribute vec4 aXYZW;attribute vec2 aUV;varying vec2 vUV;void main() {  gl_Position = uCamera * uModel * aXYZW;  vUV = aUV;}//\n#ifdef GL_ES\nprecision mediump float;\n#endif\nvarying vec2 vUV;uniform sampler2D uTex;uniform vec4 uColorM;uniform vec4 uColorA;void main() {  gl_FragColor = texture2D( uTex, vUV ) * uColorM + uColorA;}";

    public NoosaScript() {
        this.compile(this.shader());
        this.uCamera = this.uniform("uCamera");
        this.uModel = this.uniform("uModel");
        this.uTex = this.uniform("uTex");
        this.uColorM = this.uniform("uColorM");
        this.uColorA = this.uniform("uColorA");
        this.aXY = this.attribute("aXYZW");
        this.aUV = this.attribute("aUV");
    }

    @Override
    public void use() {
        super.use();
        this.aXY.enable();
        this.aUV.enable();
    }

    public void drawElements(FloatBuffer vertices, ShortBuffer indices, int size) {
        vertices.position(0);
        this.aXY.vertexPointer(2, 4, vertices);
        vertices.position(2);
        this.aUV.vertexPointer(2, 4, vertices);
        Gdx.gl.glDrawElements(4, size, 5123, indices);
    }

    public void drawQuad(FloatBuffer vertices) {
        vertices.position(0);
        this.aXY.vertexPointer(2, 4, vertices);
        vertices.position(2);
        this.aUV.vertexPointer(2, 4, vertices);
        Gdx.gl.glDrawElements(4, Quad.SIZE, 5123, Quad.INDICES_1);
    }

    public void drawQuadSet(FloatBuffer vertices, int size) {
        if (size == 0) {
            return;
        }
        vertices.position(0);
        this.aXY.vertexPointer(2, 4, vertices);
        vertices.position(2);
        this.aUV.vertexPointer(2, 4, vertices);
        Gdx.gl.glDrawElements(4, Quad.SIZE * size, 5123, Quad.getIndices(size));
    }

    public void lighting(float rm, float gm, float bm, float am, float ra, float ga, float ba, float aa) {
        this.uColorM.value4f(rm, gm, bm, am);
        this.uColorA.value4f(ra, ga, ba, aa);
    }

    public void resetCamera() {
        this.lastCamera = null;
    }

    public void camera(Camera camera) {
        if (camera == null) {
            camera = Camera.main;
        }
        if (camera != this.lastCamera) {
            this.lastCamera = camera;
            this.uCamera.valueM4(camera.matrix);
            Gdx.gl.glScissor(camera.x, Game.height - camera.screenHeight - camera.y, camera.screenWidth, camera.screenHeight);
        }
    }

    public static NoosaScript get() {
        return Script.use(NoosaScript.class);
    }

    protected String shader() {
        return SHADER;
    }
}

