/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.glwrap.Quad;
import com.watabou.noosa.NoosaScript;
import com.watabou.noosa.Visual;
import com.watabou.utils.RectF;
import java.nio.FloatBuffer;

public class NinePatch
extends Visual {
    public SmartTexture texture;
    protected float[] vertices;
    protected FloatBuffer verticesBuffer;
    protected RectF outterF;
    protected RectF innerF;
    protected int marginLeft;
    protected int marginRight;
    protected int marginTop;
    protected int marginBottom;
    protected float nWidth;
    protected float nHeight;

    public NinePatch(Object tx, int margin) {
        this(tx, margin, margin, margin, margin);
    }

    public NinePatch(Object tx, int left, int top, int right, int bottom) {
        this(tx, 0, 0, 0, 0, left, top, right, bottom);
    }

    public NinePatch(Object tx, int x, int y, int w, int h, int margin) {
        this(tx, x, y, w, h, margin, margin, margin, margin);
    }

    public NinePatch(Object tx, int x, int y, int w, int h, int left, int top, int right, int bottom) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.texture = TextureCache.get(tx);
        w = w == 0 ? this.texture.width : w;
        h = h == 0 ? this.texture.height : h;
        this.nWidth = this.width = (float)w;
        this.nHeight = this.height = (float)h;
        this.vertices = new float[16];
        this.verticesBuffer = Quad.createSet(9);
        this.marginLeft = left;
        this.marginRight = right;
        this.marginTop = top;
        this.marginBottom = bottom;
        this.outterF = this.texture.uvRect(x, y, x + w, y + h);
        this.innerF = this.texture.uvRect(x + left, y + top, x + w - right, y + h - bottom);
        this.updateVertices();
    }

    protected void updateVertices() {
        this.verticesBuffer.position(0);
        float right = this.width - (float)this.marginRight;
        float bottom = this.height - (float)this.marginBottom;
        Quad.fill(this.vertices, 0.0f, this.marginLeft, 0.0f, this.marginTop, this.outterF.left, this.innerF.left, this.outterF.top, this.innerF.top);
        this.verticesBuffer.put(this.vertices);
        Quad.fill(this.vertices, this.marginLeft, right, 0.0f, this.marginTop, this.innerF.left, this.innerF.right, this.outterF.top, this.innerF.top);
        this.verticesBuffer.put(this.vertices);
        Quad.fill(this.vertices, right, this.width, 0.0f, this.marginTop, this.innerF.right, this.outterF.right, this.outterF.top, this.innerF.top);
        this.verticesBuffer.put(this.vertices);
        Quad.fill(this.vertices, 0.0f, this.marginLeft, this.marginTop, bottom, this.outterF.left, this.innerF.left, this.innerF.top, this.innerF.bottom);
        this.verticesBuffer.put(this.vertices);
        Quad.fill(this.vertices, this.marginLeft, right, this.marginTop, bottom, this.innerF.left, this.innerF.right, this.innerF.top, this.innerF.bottom);
        this.verticesBuffer.put(this.vertices);
        Quad.fill(this.vertices, right, this.width, this.marginTop, bottom, this.innerF.right, this.outterF.right, this.innerF.top, this.innerF.bottom);
        this.verticesBuffer.put(this.vertices);
        Quad.fill(this.vertices, 0.0f, this.marginLeft, bottom, this.height, this.outterF.left, this.innerF.left, this.innerF.bottom, this.outterF.bottom);
        this.verticesBuffer.put(this.vertices);
        Quad.fill(this.vertices, this.marginLeft, right, bottom, this.height, this.innerF.left, this.innerF.right, this.innerF.bottom, this.outterF.bottom);
        this.verticesBuffer.put(this.vertices);
        Quad.fill(this.vertices, right, this.width, bottom, this.height, this.innerF.right, this.outterF.right, this.innerF.bottom, this.outterF.bottom);
        this.verticesBuffer.put(this.vertices);
    }

    public int marginLeft() {
        return this.marginLeft;
    }

    public int marginRight() {
        return this.marginRight;
    }

    public int marginTop() {
        return this.marginTop;
    }

    public int marginBottom() {
        return this.marginBottom;
    }

    public int marginHor() {
        return this.marginLeft + this.marginRight;
    }

    public int marginVer() {
        return this.marginTop + this.marginBottom;
    }

    public float innerWidth() {
        return this.width - (float)this.marginLeft - (float)this.marginRight;
    }

    public float innerHeight() {
        return this.height - (float)this.marginTop - (float)this.marginBottom;
    }

    public float innerRight() {
        return this.width - (float)this.marginRight;
    }

    public float innerBottom() {
        return this.height - (float)this.marginBottom;
    }

    public void size(float width, float height) {
        this.width = width;
        this.height = height;
        this.updateVertices();
    }

    @Override
    public void draw() {
        super.draw();
        NoosaScript script = NoosaScript.get();
        this.texture.bind();
        script.camera(this.camera());
        script.uModel.valueM4(this.matrix);
        script.lighting(this.rm, this.gm, this.bm, this.am, this.ra, this.ga, this.ba, this.aa);
        script.drawQuadSet(this.verticesBuffer, 9);
    }
}

