/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.noosa.Gizmo;
import java.util.ArrayList;

public class Group
extends Gizmo {
    protected ArrayList<Gizmo> members = new ArrayList();
    public int length = 0;

    @Override
    public void destroy() {
        for (int i = 0; i < this.length; ++i) {
            Gizmo g = this.members.get(i);
            if (g == null) continue;
            g.destroy();
        }
        this.members.clear();
        this.members = null;
        this.length = 0;
    }

    @Override
    public void update() {
        for (int i = 0; i < this.length; ++i) {
            Gizmo g = this.members.get(i);
            if (g == null || !g.exists || !g.active) continue;
            g.update();
        }
    }

    @Override
    public void draw() {
        for (int i = 0; i < this.length; ++i) {
            Gizmo g = this.members.get(i);
            if (g == null || !g.exists || !g.visible) continue;
            g.draw();
        }
    }

    @Override
    public void kill() {
        for (int i = 0; i < this.length; ++i) {
            Gizmo g = this.members.get(i);
            if (g == null || !g.exists) continue;
            g.kill();
        }
        super.kill();
    }

    public int indexOf(Gizmo g) {
        return this.members.indexOf(g);
    }

    public Gizmo add(Gizmo g) {
        if (g.parent == this) {
            return g;
        }
        if (g.parent != null) {
            g.parent.remove(g);
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.members.get(i) != null) continue;
            this.members.set(i, g);
            g.parent = this;
            return g;
        }
        this.members.add(g);
        g.parent = this;
        ++this.length;
        return g;
    }

    public Gizmo addToBack(Gizmo g) {
        if (g.parent == this) {
            this.sendToBack(g);
            return g;
        }
        if (g.parent != null) {
            g.parent.remove(g);
        }
        if (this.members.get(0) == null) {
            this.members.set(0, g);
            g.parent = this;
            return g;
        }
        this.members.add(0, g);
        g.parent = this;
        ++this.length;
        return g;
    }

    public Gizmo recycle(Class<? extends Gizmo> c) {
        Gizmo g = this.getFirstAvailable(c);
        if (g != null) {
            return g;
        }
        if (c == null) {
            return null;
        }
        try {
            return this.add(ClassReflection.newInstance(c));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Gizmo erase(Gizmo g) {
        int index = this.members.indexOf(g);
        if (index != -1) {
            this.members.set(index, null);
            g.parent = null;
            return g;
        }
        return null;
    }

    public Gizmo remove(Gizmo g) {
        if (this.members.remove(g)) {
            --this.length;
            g.parent = null;
            return g;
        }
        return null;
    }

    public Gizmo replace(Gizmo oldOne, Gizmo newOne) {
        int index = this.members.indexOf(oldOne);
        if (index != -1) {
            this.members.set(index, newOne);
            newOne.parent = this;
            oldOne.parent = null;
            return newOne;
        }
        return null;
    }

    public Gizmo getFirstAvailable(Class<? extends Gizmo> c) {
        for (int i = 0; i < this.length; ++i) {
            Gizmo g = this.members.get(i);
            if (g == null || g.exists || c != null && g.getClass() != c) continue;
            return g;
        }
        return null;
    }

    public int countLiving() {
        int count = 0;
        for (int i = 0; i < this.length; ++i) {
            Gizmo g = this.members.get(i);
            if (g == null || !g.exists || !g.alive) continue;
            ++count;
        }
        return count;
    }

    public int countDead() {
        int count = 0;
        for (int i = 0; i < this.length; ++i) {
            Gizmo g = this.members.get(i);
            if (g == null || g.alive) continue;
            ++count;
        }
        return count;
    }

    public Gizmo random() {
        if (this.length > 0) {
            return this.members.get((int)(Math.random() * (double)this.length));
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.length; ++i) {
            Gizmo g = this.members.get(i);
            if (g == null) continue;
            g.parent = null;
        }
        this.members.clear();
        this.length = 0;
    }

    public Gizmo bringToFront(Gizmo g) {
        if (this.members.contains(g)) {
            this.members.remove(g);
            this.members.add(g);
            return g;
        }
        return null;
    }

    public Gizmo sendToBack(Gizmo g) {
        if (this.members.contains(g)) {
            this.members.remove(g);
            this.members.add(0, g);
            return g;
        }
        return null;
    }
}

