/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.glscripts.Script;
import com.watabou.gltextures.TextureCache;
import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.Camera;
import com.watabou.noosa.NoosaScript;
import com.watabou.noosa.Scene;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PDPlatformSupport;
import com.watabou.utils.SystemTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Game<GameActionType>
implements ApplicationListener {
    public static Game instance;
    public static int width;
    public static int height;
    public static float density;
    public static String version;
    private final String basePath;
    private final NoosaInputProcessor<GameActionType> inputProcessor;
    private final PDPlatformSupport platformSupport;
    protected Scene scene;
    protected Scene requestedScene;
    protected boolean requestedReset = true;
    protected Class<? extends Scene> sceneClass;
    protected long now;
    protected long step;
    public static float timeScale;
    public static float elapsed;

    public Game(Class<? extends Scene> c, PDPlatformSupport<GameActionType> platformSupport) {
        this.sceneClass = c;
        this.platformSupport = platformSupport;
        this.inputProcessor = platformSupport.getInputProcessor();
        this.basePath = platformSupport.getBasePath();
    }

    @Override
    public void create() {
        instance = this;
        density = Gdx.graphics.getDensity();
        this.inputProcessor.init();
        Gdx.input.setInputProcessor(this.inputProcessor);
        this.onSurfaceCreated();
    }

    @Override
    public void resume() {
        this.now = 0L;
        Music.INSTANCE.resume();
        Sample.INSTANCE.resume();
    }

    @Override
    public void pause() {
        if (this.scene != null) {
            this.scene.pause();
        }
        Script.reset();
        Music.INSTANCE.pause();
        Sample.INSTANCE.pause();
    }

    @Override
    public void dispose() {
        this.destroyGame();
        Music.INSTANCE.mute();
        Sample.INSTANCE.reset();
    }

    @Override
    public void render() {
        if (width == 0 || height == 0) {
            return;
        }
        SystemTime.tick();
        long rightNow = SystemTime.now;
        this.step = this.now == 0L ? 0L : rightNow - this.now;
        this.now = rightNow;
        this.step();
        NoosaScript.get().resetCamera();
        Gdx.gl.glScissor(0, 0, width, height);
        Gdx.gl.glClear(16384);
        this.draw();
    }

    @Override
    public void resize(int width, int height) {
        Gdx.gl.glViewport(0, 0, width, height);
        if (width != Game.width || height != Game.height) {
            Game.width = width;
            Game.height = height;
            Scene sc = Game.scene();
            if (sc != null) {
                TextureCache.reload();
                Camera.reset();
                Game.switchScene(sc.getClass());
            }
        }
    }

    public void onSurfaceCreated() {
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        Gdx.gl.glEnable(3089);
        TextureCache.reload();
    }

    protected void destroyGame() {
        if (this.scene != null) {
            this.scene.destroy();
            this.scene = null;
        }
        instance = null;
    }

    public static void resetScene() {
        Game.switchScene(Game.instance.sceneClass);
    }

    public static void switchScene(Class<? extends Scene> c) {
        Game.instance.sceneClass = c;
        Game.instance.requestedReset = true;
    }

    public static Scene scene() {
        return Game.instance.scene;
    }

    protected void step() {
        if (this.requestedReset) {
            this.requestedReset = false;
            try {
                this.requestedScene = ClassReflection.newInstance(this.sceneClass);
                this.switchScene();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.update();
    }

    protected void draw() {
        this.scene.draw();
    }

    protected void switchScene() {
        Camera.reset();
        if (this.scene != null) {
            this.scene.destroy();
        }
        this.scene = this.requestedScene;
        this.scene.create();
        elapsed = 0.0f;
        timeScale = 1.0f;
    }

    protected void update() {
        elapsed = timeScale * (float)this.step * 0.001f;
        this.scene.update();
        Camera.updateAll();
    }

    public static void vibrate(int milliseconds) {
        Gdx.input.vibrate(milliseconds);
    }

    public boolean deleteFile(String fileName) {
        FileHandle fh = Gdx.files.external(this.basePath != null ? this.basePath + fileName : fileName);
        return fh.exists() && fh.delete();
    }

    public InputStream openFileInput(String fileName) throws IOException {
        FileHandle fh = Gdx.files.external(this.basePath != null ? this.basePath + fileName : fileName);
        if (!fh.exists()) {
            throw new IOException("File " + fileName + " doesn't exist");
        }
        return fh.read();
    }

    public OutputStream openFileOutput(String fileName) {
        FileHandle fh = Gdx.files.external(this.basePath != null ? this.basePath + fileName : fileName);
        return fh.write(false);
    }

    public void finish() {
        Gdx.app.exit();
    }

    public NoosaInputProcessor<GameActionType> getInputProcessor() {
        return this.inputProcessor;
    }

    public PDPlatformSupport getPlatformSupport() {
        return this.platformSupport;
    }

    static {
        density = 1.0f;
        timeScale = 1.0f;
        elapsed = 0.0f;
    }
}

