/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.watabou.glwrap.Matrix;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Visual;
import com.watabou.utils.Point;
import com.watabou.utils.PointF;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Camera
extends Gizmo {
    protected static ArrayList<Camera> all = new ArrayList();
    protected static float invW2;
    protected static float invH2;
    public static Camera main;
    public float zoom;
    public int x;
    public int y;
    public int width;
    public int height;
    int screenWidth;
    int screenHeight;
    public float[] matrix;
    public PointF scroll;
    public Visual target;
    private float shakeMagX = 10.0f;
    private float shakeMagY = 10.0f;
    private float shakeTime = 0.0f;
    private float shakeDuration = 1.0f;
    protected float shakeX;
    protected float shakeY;

    public static Camera reset() {
        return Camera.reset(Camera.createFullscreen(1.0f));
    }

    public static Camera reset(Camera newCamera) {
        invW2 = 2.0f / (float)Game.width;
        invH2 = 2.0f / (float)Game.height;
        int length = all.size();
        for (int i = 0; i < length; ++i) {
            all.get(i).destroy();
        }
        all.clear();
        main = Camera.add(newCamera);
        return main;
    }

    public static Camera add(Camera camera) {
        all.add(camera);
        return camera;
    }

    public static Camera remove(Camera camera) {
        all.remove(camera);
        return camera;
    }

    public static void updateAll() {
        int length = all.size();
        for (int i = 0; i < length; ++i) {
            Camera c = all.get(i);
            if (!c.exists || !c.active) continue;
            c.update();
        }
    }

    public static Camera createFullscreen(float zoom) {
        int w = (int)Math.ceil((float)Game.width / zoom);
        int h = (int)Math.ceil((float)Game.height / zoom);
        return new Camera((int)((float)Game.width - (float)w * zoom) / 2, (int)((float)Game.height - (float)h * zoom) / 2, w, h, zoom);
    }

    public Camera(int x, int y, int width, int height, float zoom) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.zoom = zoom;
        this.screenWidth = (int)((float)width * zoom);
        this.screenHeight = (int)((float)height * zoom);
        this.scroll = new PointF();
        this.matrix = new float[16];
        Matrix.setIdentity(this.matrix);
    }

    @Override
    public void destroy() {
        this.target = null;
        this.matrix = null;
    }

    public void zoom(float value) {
        this.zoom(value, this.scroll.x + (float)(this.width / 2), this.scroll.y + (float)(this.height / 2));
    }

    public void zoom(float value, float fx, float fy) {
        this.zoom = value;
        this.width = (int)((float)this.screenWidth / this.zoom);
        this.height = (int)((float)this.screenHeight / this.zoom);
        this.focusOn(fx, fy);
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.screenWidth = (int)((float)width * this.zoom);
        this.screenHeight = (int)((float)height * this.zoom);
    }

    @Override
    public void update() {
        float f;
        super.update();
        if (this.target != null) {
            this.focusOn(this.target);
        }
        this.shakeTime -= Game.elapsed;
        if (f > 0.0f) {
            float damping = this.shakeTime / this.shakeDuration;
            this.shakeX = Random.Float(-this.shakeMagX, this.shakeMagX) * damping;
            this.shakeY = Random.Float(-this.shakeMagY, this.shakeMagY) * damping;
        } else {
            this.shakeX = 0.0f;
            this.shakeY = 0.0f;
        }
        this.updateMatrix();
    }

    public PointF center() {
        return new PointF(this.width / 2, this.height / 2);
    }

    public boolean hitTest(float x, float y) {
        return x >= (float)this.x && y >= (float)this.y && x < (float)(this.x + this.screenWidth) && y < (float)(this.y + this.screenHeight);
    }

    public void focusOn(float x, float y) {
        this.scroll.set(x - (float)(this.width / 2), y - (float)(this.height / 2));
    }

    public void focusOn(PointF point) {
        this.focusOn(point.x, point.y);
    }

    public void focusOn(Visual visual) {
        this.focusOn(visual.center());
    }

    public PointF screenToCamera(int x, int y) {
        return new PointF((float)(x - this.x) / this.zoom + this.scroll.x, (float)(y - this.y) / this.zoom + this.scroll.y);
    }

    public Point cameraToScreen(float x, float y) {
        return new Point((int)((x - this.scroll.x) * this.zoom + (float)this.x), (int)((y - this.scroll.y) * this.zoom + (float)this.y));
    }

    public float screenWidth() {
        return (float)this.width * this.zoom;
    }

    public float screenHeight() {
        return (float)this.height * this.zoom;
    }

    protected void updateMatrix() {
        this.matrix[0] = this.zoom * invW2;
        this.matrix[5] = -this.zoom * invH2;
        this.matrix[12] = -1.0f + (float)this.x * invW2 - (this.scroll.x + this.shakeX) * this.matrix[0];
        this.matrix[13] = 1.0f - (float)this.y * invH2 - (this.scroll.y + this.shakeY) * this.matrix[5];
    }

    public void shake(float magnitude, float duration) {
        this.shakeMagX = this.shakeMagY = magnitude;
        this.shakeTime = this.shakeDuration = duration;
    }
}

