/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.watabou.gdx.GdxTexture;
import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.glwrap.Matrix;
import com.watabou.glwrap.Quad;
import com.watabou.noosa.NoosaScript;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.Visual;
import com.watabou.utils.RectF;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import net.whitegem.pixeldungeon.LanguageFactory;

public class BitmapText
extends Visual {
    protected String text;
    protected Font font;
    protected float[] vertices = new float[16];
    protected FloatBuffer quads;
    public int realLength;
    protected boolean dirty = true;

    public BitmapText() {
        this("", null);
    }

    public BitmapText(Font font) {
        this("", font);
    }

    public BitmapText(String text, Font font) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.text = text;
        this.text = LanguageFactory.getTranslation(text);
        this.font = font;
    }

    @Override
    public void destroy() {
        this.text = null;
        this.font = null;
        this.vertices = null;
        this.quads = null;
        super.destroy();
    }

    @Override
    protected void updateMatrix() {
        Matrix.setIdentity(this.matrix);
        Matrix.translate(this.matrix, this.x, this.y);
        Matrix.scale(this.matrix, this.scale.x, this.scale.y);
        Matrix.rotate(this.matrix, this.angle);
    }

    @Override
    public void draw() {
        super.draw();
        NoosaScript script = NoosaScript.get();
        this.font.texture.bind();
        if (this.dirty) {
            this.updateVertices();
        }
        script.camera(this.camera());
        script.uModel.valueM4(this.matrix);
        script.lighting(this.rm, this.gm, this.bm, this.am, this.ra, this.ga, this.ba, this.aa);
        script.drawQuadSet(this.quads, this.realLength);
    }

    protected void updateVertices() {
        this.width = 0.0f;
        this.height = 0.0f;
        if (this.text == null) {
            this.text = "";
        }
        this.quads = Quad.createSet(this.text.length());
        this.realLength = 0;
        int length = this.text.length();
        for (int i = 0; i < length; ++i) {
            RectF rect = this.font.get(this.text.charAt(i));
            if (rect == null) {
                rect = null;
            }
            float w = this.font.width(rect);
            float h = this.font.height(rect);
            this.vertices[0] = this.width;
            this.vertices[1] = 0.0f;
            this.vertices[2] = rect.left;
            this.vertices[3] = rect.top;
            this.vertices[4] = this.width + w;
            this.vertices[5] = 0.0f;
            this.vertices[6] = rect.right;
            this.vertices[7] = rect.top;
            this.vertices[8] = this.width + w;
            this.vertices[9] = h;
            this.vertices[10] = rect.right;
            this.vertices[11] = rect.bottom;
            this.vertices[12] = this.width;
            this.vertices[13] = h;
            this.vertices[14] = rect.left;
            this.vertices[15] = rect.bottom;
            this.quads.put(this.vertices);
            ++this.realLength;
            this.width += w + this.font.tracking;
            if (!(h > this.height)) continue;
            this.height = h;
        }
        if (length > 0) {
            this.width -= this.font.tracking;
        }
        this.dirty = false;
    }

    public void measure() {
        this.width = 0.0f;
        this.height = 0.0f;
        if (this.text == null) {
            this.text = "";
        }
        int length = this.text.length();
        for (int i = 0; i < length; ++i) {
            RectF rect = this.font.get(this.text.charAt(i));
            float w = this.font.width(rect);
            float h = this.font.height(rect);
            this.width += w + this.font.tracking;
            if (!(h > this.height)) continue;
            this.height = h;
        }
        if (length > 0) {
            this.width -= this.font.tracking;
        }
    }

    public float baseLine() {
        return this.font.baseLine * this.scale.y;
    }

    public Font font() {
        return this.font;
    }

    public void font(Font value) {
        this.font = value;
    }

    public String text() {
        return this.text;
    }

    public void text(String str1, String str2) {
        this.text = str1 + " " + LanguageFactory.getTranslation(str2);
        this.dirty = true;
    }

    public void text(String str) {
        this.text = str;
        this.text = LanguageFactory.getTranslation(this.text);
        this.dirty = true;
    }

    public static class Font
    extends TextureFilm {
        public static final String LATIN_UPPER = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        public static final String LATIN_FULL = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
        public SmartTexture texture;
        public float tracking = 0.0f;
        public float baseLine;
        public boolean autoUppercase = false;
        public float lineHeight;

        protected Font(SmartTexture tx) {
            super(tx);
            this.texture = tx;
        }

        public Font(SmartTexture tx, int width, String chars) {
            this(tx, width, tx.height, chars);
        }

        public Font(SmartTexture tx, int width, int height, String chars) {
            super(tx);
            this.texture = tx;
            this.autoUppercase = chars.equals(LATIN_UPPER);
            int length = chars.length();
            float uw = (float)width / (float)tx.width;
            float vh = (float)height / (float)tx.height;
            float left = 0.0f;
            float top = 0.0f;
            float bottom = vh;
            for (int i = 0; i < length; ++i) {
                RectF rect = new RectF(left, top, left += uw, bottom);
                this.add(Character.valueOf(chars.charAt(i)), rect);
                if (!(left >= 1.0f)) continue;
                left = 0.0f;
                top = bottom;
                bottom += vh;
            }
            this.lineHeight = this.baseLine = (float)height;
        }

        private ArrayList<FntFileChar> processFntFile(String fntFile, int scale) {
            ArrayList<FntFileChar> chars = new ArrayList<FntFileChar>();
            FileHandle file = Gdx.files.internal(fntFile);
            BufferedReader reader = new BufferedReader(file.reader());
            ArrayList<String> lines = new ArrayList<String>();
            int start = 0;
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (!line.trim().equals("") && ++start >= 5) {
                        lines.add(line.trim());
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            for (String line : lines) {
                String[] objs = line.split("\\s+");
                String id = objs[1].split("=")[1];
                String x = objs[2].split("=")[1];
                String y = objs[3].split("=")[1];
                String w = objs[4].split("=")[1];
                String h = objs[5].split("=")[1];
                String xo = objs[6].split("=")[1];
                String yo = objs[7].split("=")[1];
                int idi = Integer.parseInt(id);
                int xi = Integer.parseInt(x);
                int yi = Integer.parseInt(y);
                int wi = Integer.parseInt(w);
                int hi = Integer.parseInt(h);
                int xoi = Integer.parseInt(xo);
                int yoi = Integer.parseInt(yo);
                char idc = (char)idi;
                FntFileChar ffc = new FntFileChar(idc, xi * scale, yi * scale, wi * scale, hi * scale, xoi * scale, yoi * scale);
                chars.add(ffc);
            }
            return chars;
        }

        protected void splitBy(GdxTexture bitmap, int height, int color, String chars, String fntFile, int scale) {
            this.autoUppercase = false;
            ArrayList<FntFileChar> realChars = this.processFntFile(fntFile, scale);
            int width = bitmap.getWidth();
            int length = realChars.size();
            TextureData td = bitmap.getTextureData();
            if (!td.isPrepared()) {
                td.prepare();
            }
            Pixmap pixmap = td.consumePixmap();
            for (int i = 0; i < length; ++i) {
                FntFileChar ch = realChars.get(i);
                if (ch.c == ' ') {
                    this.add(Character.valueOf(ch.c), new RectF(1.0f - (float)ch.height / 2.0f / (float)width, 1.0f - (float)ch.height / (float)height, 1.0f, 1.0f));
                    continue;
                }
                this.add(Character.valueOf(ch.c), new RectF((float)ch.x / (float)width, (float)ch.y / (float)height, (float)(ch.x + ch.width) / (float)width, (float)(ch.y + ch.height) / (float)height));
            }
            pixmap.dispose();
            this.lineHeight = this.baseLine = this.height((RectF)this.frames.get(Character.valueOf(realChars.get((int)0).c)));
        }

        protected void splitBy(GdxTexture bitmap, int height, int color, String chars) {
            int pos;
            this.autoUppercase = chars.equals(LATIN_UPPER);
            int length = chars.length();
            int width = bitmap.getWidth();
            float vHeight = (float)height / (float)bitmap.getHeight();
            TextureData td = bitmap.getTextureData();
            if (!td.isPrepared()) {
                td.prepare();
            }
            Pixmap pixmap = td.consumePixmap();
            block0: for (pos = 0; pos < width; ++pos) {
                for (int j = 0; j < height; ++j) {
                    if (this.colorNotMatch(pixmap, pos, j, color)) break block0;
                }
            }
            this.add(Character.valueOf(' '), new RectF(0.0f, 0.0f, (float)pos / (float)width, vHeight));
            for (int i = 0; i < length; ++i) {
                char ch = chars.charAt(i);
                if (ch == ' ') continue;
                int separator = pos;
                while (++separator < width) {
                    boolean found = true;
                    for (int j = 0; j < height; ++j) {
                        if (!this.colorNotMatch(pixmap, separator, j, color)) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                }
                this.add(Character.valueOf(ch), new RectF((float)pos / (float)width, 0.0f, (float)separator / (float)width, vHeight));
                pos = separator + 1;
            }
            pixmap.dispose();
            this.lineHeight = this.baseLine = this.height((RectF)this.frames.get(Character.valueOf(chars.charAt(0))));
        }

        private boolean colorNotMatch(Pixmap pixmap, int x, int y, int color) {
            int pixel = pixmap.getPixel(x, y);
            if ((pixel & 0xFF) == 0) {
                return color != 0;
            }
            return pixel != color;
        }

        public static Font colorMarked(GdxTexture bmp, int color, String chars) {
            Font font = new Font(TextureCache.get(bmp));
            font.splitBy(bmp, bmp.getHeight(), color, chars);
            return font;
        }

        public static Font colorMarked(GdxTexture bmp, int height, int color, String chars) {
            Font font = new Font(TextureCache.get(bmp));
            font.splitBy(bmp, height, color, chars);
            return font;
        }

        public static Font colorMarked(GdxTexture bmp, int color, String chars, String fntFile, int scale) {
            Font font = new Font(TextureCache.get(bmp));
            font.splitBy(bmp, bmp.getHeight(), color, chars, fntFile, scale);
            return font;
        }

        public static Font colorMarked(GdxTexture bmp, int height, int color, String chars, String fntFile, int scale) {
            Font font = new Font(TextureCache.get(bmp));
            font.splitBy(bmp, height, color, chars, fntFile, scale);
            return font;
        }

        public RectF get(char ch) {
            return super.get(Character.valueOf(this.autoUppercase ? Character.toUpperCase(ch) : ch));
        }

        private class FntFileChar {
            protected char c;
            protected int x;
            protected int y;
            protected int width;
            protected int height;
            protected int x_offset;
            protected int y_offset;

            public FntFileChar(char c, int x, int y, int width, int height, int x_offset, int y_offset) {
                this.c = c;
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                this.x_offset = x_offset;
                this.y_offset = y_offset;
            }
        }
    }
}

