/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.input;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.IntMap;
import com.watabou.utils.PointF;
import com.watabou.utils.Signal;

public abstract class NoosaInputProcessor<T>
implements InputProcessor {
    protected Signal<Key<T>> eventKey = new Signal(true);
    protected Signal<Touch> eventTouch = new Signal(true);
    protected Signal<PDMouseEvent> eventMouse = new Signal(true);
    protected IntMap<Touch> pointers = new IntMap();
    public static final int MODIFIER_KEY = 129;
    public static boolean modifier = false;

    public void init() {
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 24: 
            case 25: {
                return false;
            }
            case 129: {
                modifier = true;
            }
        }
        this.eventKey.dispatch(new Key<T>(keycode, this.keycodeToGameAction(keycode), true));
        return true;
    }

    protected abstract T keycodeToGameAction(int var1);

    @Override
    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 24: 
            case 25: {
                return false;
            }
            case 129: {
                modifier = false;
            }
        }
        this.eventKey.dispatch(new Key<T>(keycode, this.keycodeToGameAction(keycode), false));
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        this.eventMouse.dispatch(new PDMouseEvent(amount));
        return true;
    }

    public void addKeyListener(Signal.Listener<Key<T>> listener) {
        this.eventKey.add(listener);
    }

    public void removeKeyListener(Signal.Listener<Key<T>> listener) {
        this.eventKey.remove(listener);
    }

    public void addTouchListener(Signal.Listener<Touch> listener) {
        this.eventTouch.add(listener);
    }

    public void removeTouchListener(Signal.Listener<Touch> listener) {
        this.eventTouch.remove(listener);
    }

    public void addMouseListener(Signal.Listener<PDMouseEvent> listener) {
        this.eventMouse.add(listener);
    }

    public void removeMouseListener(Signal.Listener<PDMouseEvent> listener) {
        this.eventMouse.remove(listener);
    }

    public void cancelKeyEvent() {
        this.eventKey.cancel();
    }

    public void cancelTouchEvent() {
        this.eventTouch.cancel();
    }

    public void cancelMouseEvent() {
        this.eventMouse.cancel();
    }

    public void removeAllKeyEvent() {
        this.eventKey.removeAll();
    }

    public void removeAllTouchEvent() {
        this.eventTouch.removeAll();
    }

    public void removeAllMouseEvent() {
        this.eventMouse.removeAll();
    }

    public static class Touch {
        public PointF start;
        public PointF current;
        public boolean down;

        public Touch(int x, int y) {
            this.start = new PointF(x, y);
            this.current = new PointF(x, y);
            this.down = true;
        }

        public void update(int x, int y) {
            this.current.set(x, y);
        }

        public Touch up() {
            this.down = false;
            return this;
        }
    }

    public static class Key<T> {
        public final int code;
        public final T action;
        public final boolean pressed;

        public Key(int code, T action, boolean pressed) {
            this.code = code;
            this.action = action;
            this.pressed = pressed;
        }
    }

    public static class PDMouseEvent {
        public final int scroll;

        public PDMouseEvent(int scroll) {
            this.scroll = scroll;
        }
    }
}

