/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.glwrap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.watabou.gdx.GdxTexture;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class Texture {
    public boolean premultiplied = false;
    public GdxTexture bitmap;

    protected Texture(GdxTexture bitmap) {
        this.bitmap = bitmap;
    }

    public static void activate(int index) {
        Gdx.gl.glActiveTexture(33984 + index);
    }

    public void bind() {
        this.bitmap.bind();
    }

    public void filter(Texture.TextureFilter minMode, Texture.TextureFilter maxMode) {
        this.bitmap.setFilter(minMode, maxMode);
    }

    public void wrap(Texture.TextureWrap u, Texture.TextureWrap v) {
        this.bitmap.setWrap(u, v);
    }

    public void delete() {
        this.bitmap.dispose();
    }

    public void bitmap(GdxTexture bitmap) {
        this.bitmap = bitmap;
        this.premultiplied = true;
    }

    public void pixels(int w, int h, int[] pixels) {
        this.bind();
        IntBuffer imageBuffer = ByteBuffer.allocateDirect(w * h * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        imageBuffer.put(pixels);
        imageBuffer.position(0);
        Gdx.gl.glTexImage2D(3553, 0, 6408, w, h, 0, 6408, 5121, imageBuffer);
    }

    public void pixels(int w, int h, byte[] pixels) {
        this.bind();
        ByteBuffer imageBuffer = ByteBuffer.allocateDirect(w * h).order(ByteOrder.nativeOrder());
        imageBuffer.put(pixels);
        imageBuffer.position(0);
        Gdx.gl.glPixelStorei(3317, 1);
        Gdx.gl.glTexImage2D(3553, 0, 6406, w, h, 0, 6406, 5121, imageBuffer);
    }

    public void handMade(GdxTexture bitmap, boolean recode) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pixels = new int[w * h];
        if (recode) {
            for (int i = 0; i < pixels.length; ++i) {
                int color = pixels[i];
                int ag = color & 0xFF00FF00;
                int r = color >> 16 & 0xFF;
                int b = color & 0xFF;
                pixels[i] = ag | b << 16 | r;
            }
        }
        this.pixels(w, h, pixels);
        this.premultiplied = false;
    }

    public static Texture create(GdxTexture bmp) {
        return new Texture(bmp);
    }

    public static Texture create(int width, int height, int[] pixels) {
        Texture tex = new Texture(null);
        tex.pixels(width, height, pixels);
        return tex;
    }

    public static Texture create(int width, int height, byte[] pixels) {
        Texture tex = new Texture(null);
        tex.pixels(width, height, pixels);
        return tex;
    }
}

