/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.glwrap;

public class Matrix {
    public static final float G2RAD = (float)Math.PI / 180;

    public static float[] clone(float[] m) {
        int n = m.length;
        float[] res = new float[n];
        do {
            res[--n] = m[n];
        } while (n > 0);
        return res;
    }

    public static void copy(float[] src, float[] dst) {
        int n = src.length;
        do {
            dst[--n] = src[n];
        } while (n > 0);
    }

    public static void setIdentity(float[] m) {
        int i;
        for (i = 0; i < 16; ++i) {
            m[i] = 0.0f;
        }
        for (i = 0; i < 16; i += 5) {
            m[i] = 1.0f;
        }
    }

    public static void rotate(float[] m, float a) {
        float sin = (float)Math.sin(a *= (float)Math.PI / 180);
        float cos = (float)Math.cos(a);
        float m0 = m[0];
        float m1 = m[1];
        float m4 = m[4];
        float m5 = m[5];
        m[0] = m0 * cos + m4 * sin;
        m[1] = m1 * cos + m5 * sin;
        m[4] = -m0 * sin + m4 * cos;
        m[5] = -m1 * sin + m5 * cos;
    }

    public static void skewX(float[] m, float a) {
        double t = Math.tan(a * ((float)Math.PI / 180));
        m[4] = (float)((double)m[4] + (double)(-m[0]) * t);
        m[5] = (float)((double)m[5] + (double)(-m[1]) * t);
    }

    public static void skewY(float[] m, float a) {
        double t = Math.tan(a * ((float)Math.PI / 180));
        m[0] = (float)((double)m[0] + (double)m[4] * t);
        m[1] = (float)((double)m[1] + (double)m[5] * t);
    }

    public static void scale(float[] m, float x, float y) {
        m[0] = m[0] * x;
        m[1] = m[1] * x;
        m[2] = m[2] * x;
        m[3] = m[3] * x;
        m[4] = m[4] * y;
        m[5] = m[5] * y;
        m[6] = m[6] * y;
        m[7] = m[7] * y;
    }

    public static void translate(float[] m, float x, float y) {
        m[12] = m[12] + (m[0] * x + m[4] * y);
        m[13] = m[13] + (m[1] * x + m[5] * y);
    }

    public static void multiply(float[] left, float[] right, float[] result) {
        float ax1 = left[0];
        float ay1 = left[1];
        float az1 = left[2];
        float aw1 = left[3];
        float ax2 = left[4];
        float ay2 = left[5];
        float az2 = left[6];
        float aw2 = left[7];
        float ax3 = left[8];
        float ay3 = left[9];
        float az3 = left[10];
        float aw3 = left[11];
        float ax4 = left[12];
        float ay4 = left[13];
        float az4 = left[14];
        float aw4 = left[15];
        float bx1 = right[0];
        float by1 = right[1];
        float bz1 = right[2];
        float bw1 = right[3];
        float bx2 = right[4];
        float by2 = right[5];
        float bz2 = right[6];
        float bw2 = right[7];
        float bx3 = right[8];
        float by3 = right[9];
        float bz3 = right[10];
        float bw3 = right[11];
        float bx4 = right[12];
        float by4 = right[13];
        float bz4 = right[14];
        float bw4 = right[15];
        result[0] = ax1 * bx1 + ax2 * by1 + ax3 * bz1 + ax4 * bw1;
        result[1] = ay1 * bx1 + ay2 * by1 + ay3 * bz1 + ay4 * bw1;
        result[2] = az1 * bx1 + az2 * by1 + az3 * bz1 + az4 * bw1;
        result[3] = aw1 * bx1 + aw2 * by1 + aw3 * bz1 + aw4 * bw1;
        result[4] = ax1 * bx2 + ax2 * by2 + ax3 * bz2 + ax4 * bw2;
        result[5] = ay1 * bx2 + ay2 * by2 + ay3 * bz2 + ay4 * bw2;
        result[6] = az1 * bx2 + az2 * by2 + az3 * bz2 + az4 * bw2;
        result[7] = aw1 * bx2 + aw2 * by2 + aw3 * bz2 + aw4 * bw2;
        result[8] = ax1 * bx3 + ax2 * by3 + ax3 * bz3 + ax4 * bw3;
        result[9] = ay1 * bx3 + ay2 * by3 + ay3 * bz3 + ay4 * bw3;
        result[10] = az1 * bx3 + az2 * by3 + az3 * bz3 + az4 * bw3;
        result[11] = aw1 * bx3 + aw2 * by3 + aw3 * bz3 + aw4 * bw3;
        result[12] = ax1 * bx4 + ax2 * by4 + ax3 * bz4 + ax4 * bw4;
        result[13] = ay1 * bx4 + ay2 * by4 + ay3 * bz4 + ay4 * bw4;
        result[14] = az1 * bx4 + az2 * by4 + az3 * bz4 + az4 * bw4;
        result[15] = aw1 * bx4 + aw2 * by4 + aw3 * bz4 + aw4 * bw4;
    }
}

