/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.gltextures;

import com.badlogic.gdx.graphics.Pixmap;
import com.watabou.gdx.GdxTexture;
import com.watabou.gltextures.SmartTexture;
import com.watabou.glwrap.Texture;
import java.util.HashMap;

public class TextureCache {
    private static HashMap<Object, SmartTexture> all = new HashMap();

    public static SmartTexture createSolid(int color) {
        String key = "1x1:" + color;
        if (all.containsKey(key)) {
            return all.get(key);
        }
        Pixmap pixmap = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        pixmap.setColor(color << 8 | color >>> 24);
        pixmap.fill();
        GdxTexture bmp = new GdxTexture(pixmap);
        SmartTexture tx = new SmartTexture(bmp);
        all.put(key, tx);
        return tx;
    }

    public static void add(Object key, SmartTexture tx) {
        all.put(key, tx);
    }

    public static SmartTexture get(Object src) {
        if (all.containsKey(src)) {
            return all.get(src);
        }
        if (src instanceof SmartTexture) {
            return (SmartTexture)src;
        }
        SmartTexture tx = new SmartTexture(TextureCache.getBitmap(src));
        all.put(src, tx);
        return tx;
    }

    public static void clear() {
        for (Texture texture : all.values()) {
            texture.delete();
        }
        all.clear();
    }

    public static void reload() {
        for (SmartTexture tx : all.values()) {
            tx.reload();
        }
    }

    public static GdxTexture getBitmap(Object src) {
        try {
            if (src instanceof Integer) {
                throw new UnsupportedOperationException();
            }
            if (src instanceof String) {
                return new GdxTexture((String)src);
            }
            if (src instanceof GdxTexture) {
                return (GdxTexture)src;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean contains(Object key) {
        return all.containsKey(key);
    }
}

