/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.gltextures;

import com.badlogic.gdx.graphics.Texture;
import com.watabou.gdx.GdxTexture;
import com.watabou.gltextures.Atlas;
import com.watabou.glwrap.Texture;
import com.watabou.utils.RectF;

public class SmartTexture
extends Texture {
    public int width;
    public int height;
    public Texture.TextureFilter fModeMin;
    public Texture.TextureFilter fModeMax;
    public Texture.TextureWrap wModeH;
    public Texture.TextureWrap wModeV;
    public Atlas atlas;

    public SmartTexture(GdxTexture bitmap) {
        this(bitmap, Texture.TextureFilter.Nearest, Texture.TextureWrap.ClampToEdge);
    }

    public SmartTexture(GdxTexture bitmap, Texture.TextureFilter filtering, Texture.TextureWrap wrapping) {
        super(bitmap);
        this.width = bitmap.getWidth();
        this.height = bitmap.getHeight();
        this.filter(filtering, filtering);
        this.wrap(wrapping, wrapping);
    }

    @Override
    public void filter(Texture.TextureFilter minMode, Texture.TextureFilter maxMode) {
        this.fModeMin = minMode;
        this.fModeMax = maxMode;
        super.filter(this.fModeMin, this.fModeMax);
    }

    @Override
    public void wrap(Texture.TextureWrap u, Texture.TextureWrap v) {
        this.wModeH = u;
        this.wModeV = v;
        super.wrap(this.wModeH, this.wModeV);
    }

    @Override
    public void bitmap(GdxTexture bitmap) {
        this.bitmap(bitmap, false);
    }

    public void bitmap(GdxTexture bitmap, boolean premultiplied) {
        if (premultiplied) {
            super.bitmap(bitmap);
        } else {
            this.handMade(bitmap, true);
        }
        this.bitmap = bitmap;
        this.width = bitmap.getWidth();
        this.height = bitmap.getHeight();
    }

    public void reload() {
        this.filter(this.fModeMin, this.fModeMax);
        this.wrap(this.wModeH, this.wModeV);
    }

    @Override
    public void delete() {
        super.delete();
        this.bitmap.dispose();
        this.bitmap = null;
    }

    public RectF uvRect(int left, int top, int right, int bottom) {
        return new RectF((float)left / (float)this.width, (float)top / (float)this.height, (float)right / (float)this.width, (float)bottom / (float)this.height);
    }
}

