/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.glscripts;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.glwrap.Program;
import com.watabou.glwrap.Shader;
import java.util.HashMap;

public class Script
extends Program {
    private static final HashMap<Class<? extends Script>, Script> all = new HashMap();
    private static Script curScript = null;
    private static Class<? extends Script> curScriptClass = null;

    public static <T extends Script> T use(Class<T> c) {
        if (c != curScriptClass) {
            Script script = all.get(c);
            if (script == null) {
                try {
                    script = (Script)ClassReflection.newInstance(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                all.put(c, script);
            }
            if (curScript != null) {
                curScript.unuse();
            }
            curScript = script;
            curScriptClass = c;
            curScript.use();
        }
        return (T)curScript;
    }

    public static void reset() {
        for (Script script : all.values()) {
            script.delete();
        }
        all.clear();
        curScript = null;
        curScriptClass = null;
    }

    public void compile(String src) {
        String[] srcShaders = src.split("//\n");
        this.attach(Shader.createCompiled(35633, srcShaders[0]));
        this.attach(Shader.createCompiled(35632, srcShaders[1]));
        this.link();
    }

    public void unuse() {
    }
}

