import * as z from 'zod'

export const registrySchema = z.array(
  z.object({
    name: z.string(),
    dependencies: z.array(z.string()).optional(),
    registryDependencies: z.array(z.string()).optional(),
    files: z.array(z.string()),
    type: z.enum([
      'components:ui',
      'components:component',
      'components:example',
      'components:block',
    ]),
  }),
)

export type Registry = z.infer<typeof registrySchema>
