---
title: Surrealist 3.1
date: 2024/11/26
---

- You can now open and edit query files directly in Surrealist Desktop
    - Files can be opened through `ctrl/cmd + O`, the “Open query file” command, or by opening the file on your system with Surrealist
    - Changes you make are automatically saved back to disk, much like regular query tabs
    - Files are opened within the current connection, meaning you can open files in different connections and keep these separated
    - Added a context menu item to reveal the file in your file explorer
- Added support for keybinding customisation
    - Configurable in a new Keybindings page in settings
    - Most commands, including dynamically generated ones, can be bound
    - Default bindings can be cleared, and custom bindings can easily be reset
    - Displayed in the command palette
- The query panel and tables panel in the Query and Explorer views can now be collapsed
    - The explorer tables panel will always be visible when no table is selected
- Added integrated SurrealDB documentation searching
    - Accessible with cmd + J or with the “Search SurrealDB documentation” command
    - Functions identical to search within the docs
    - Opens the relevant page in your browser
- Redesigned settings dialog
    - Merged Behaviour and Appearance into a new searchable Preferences category
    - Added a new Backup & Restore category
    - Added a new About category detailing build information
    - Moved environment copy to the About page
- Improved Designer view table graph rendering
    - Relation lines will now render next to each other and avoid overlapping where possible
    - Relation lines now indicate their direction using an arrow
    - Improved the performance and reliability of the table graph
- Added inline preference editing in Surrealist Search
    - The command list will now display matching preferences when searched for
    - These can be edited inline for convenience
    - Fully accessible and keyboard navigable
- Added configuration backups & restoring
    - Allows saving your Surrealist configuration and restoring at a later date
    - Provides the option to strip sensitive information
    - Allows exporting only specific connections
- Improved and optimised the query history
    - Large queries will no longer be saved to the query history
    - When a query is too large to be saved, an indicator will show up notifying you of this
    - Entries within the query history will be truncated when too long
    - It is now easier to delete and run query history entries
- Improved the result formatting setting
    - Configurable per connection directly from the query result panel
    - Allows representing query results as SurrealQL or JSON
- Improved config serialisation in the web app
    - The config will now be stored in IndexedDB
    - This should result in improved performance
- Improved namespace and database creation
    - The namespace and database selection dropdowns will automatically open the creator dialog when no existing entries are found
- Added a setting to toggle line numbers in different editors
    - Currently available for the query editor, record inspector, and functions editor
    - Also configurable for Surrealist Mini
- Accessibility improvements
    - Made various dialogs easier to use when navigating with a keyboard
- Improved query result rendering
    - Queries are now selected from a dropdown
    - Table rendering now supports full pagination
- Improved Designer table graph settings
    - Globally configurable default values in the settings menu
    - Added the option to use a more spaced out layout algorithm
    - Added per-connection line style customisation
    - Enabled record link rendering by default
- Added new default keybindings
    - `Ctrl/Cmd + T` to open a new query tab (Desktop only)
    - `Ctrl/cmd + W` to close the current query tab (Desktop only)
    - `Ctrl/cmd + N` to create a new table (Desktop only)
- Added a new editor shortcut to select the entire query your cursor is inside of
    - Bound to `Ctrl/cmd + E`
- Added a new table context menu option to display the full table definition
- The record inspector will now display errors encountered while saving
- Updated SurrealQL highlighting to support new SurrealDB 2.1 features
- Added a Sync schema button to the connection dropdown
- Added a “Focus table” context menu option to focus tables in the table graph from the table list
- Added a “Rename” option to query tab context menus
- Added the option to view the status of nodes in the cluster
- Added back database export customisation options
- Improved table designer field, event, and index editing
- Added a confirmation before deleting a record from the Explorer
- Added a new setting to disable quick query closing
- Added editor warnings when trying to use unsupported SurrealQL features
- Improved the editing of connections in the connections list
- Surrealist is now available as a Docker image
- Fixed explorer pagination not adjusting when changing max results per page
- Fixed the designer help button not working
- Fixed situations where Surrealist could crash with “Session unavailable”
- Fixed query tabs not being editable on Firefox
- Fixed query tabs allowing empty names
- Fixed Surrealist rendering blank on Linux systems using Nvidia graphics
- Fixed record access sign up modal inputs not working correctly
- Fixed connection templates not saving