---
title: Surrealist 3.0
date: 2024/09/17
---

### Highlights

- Improved namespace and database selection
	- Connect to an instance without selecting a namespace or database
	- Switch namespaces and databases on-the-fly
	- Create and remove namespaces and databases directly from the toolbar
	- Redesigned connection editor
- New GraphQL view
	- Execute GraphQL queries against a database using the new GraphQL view
	- Live query validation and error checking
	- Full GraphQL syntax highlighting
	- Full support for query variables
- Overhauled Authentication view
	- Redesigned to be compatible with SurrealDB 2.0 authentication
	- Manage system users and access methods on a root, namespace, and database level
	- Configure authentication through redesigned editor dialogs
- Light interface theme
	- The Light interface theme has made a spectacular comeback
	- New design supported across the entire interface
	- Synchronise theme to your operating system’s preference
- Designer view improvements
	- New expandable table list
	- Persistent expanded table designer sections
	- New system warning for potential schema issues

### Other changes

- Redesigned start screen with a new appearance, useful resources, and latest news
- Query formatting support for the functions view
- The sidebar is now organised more logically
- Maximum size of resizable drawers has been increased
- Customize the history size and log level of the database serving console
- Query view variable panel expansion state is now saved persistently
- Functions editor now auto completes arguments, tables, and other functions
- Updated SurrealQL highlighting to support new SurrealDB 2.0 features
- Highlighting for regular expressions in query editors
- New collapsible table list in the Designer view
- Improved appearance of edge tables in the Designer view
- Designer view will now report on schema configuration warnings
- Added the option to initialise any empty database with a demo dataset
- Decreased the minimum window size for Surrealist Desktop
- Initial work on making the interface mobile compatible
- Improved listing of fields and indexes in the Table Designer
- Remember expanded Table Designer panels persistently
- Improved search behaviour in the tables panel
- Slightly changed the appearance of drawers

### Bug fixes

- Performance improvements for large schemas
- Performance improvements for Designer view record link visualisation
- Performance improvements when navigating the explorer view
- Fixed designer field and table permissions initialising incorrectly
- Fixed explorer object tooltip indenting
- Fixed incorrect editor highlighting keywords
- Fixed Designer view performance issues when visualising record links
- Fixed backspace deleting nodes in the Designer view
- Fixed designer permission fields incorrectly including WHERE keyword
- Fixed indenting in data table tooltips
- Fixed unintended scrollbars rendering on Windows
- Fixed null geo coordinates crashing Surrealist
- Fixed the geography explorer not always updating
- Fixed live messages displaying incorrect timestamps
- Fixed record ids within live message previews not being clickable
- Fixed the designer view not changing incoming/outgoing tables on relation tables
- Fixed incorrect Surrealist Mini embed URL generation