---
title: Surrealist 2.0
date: 2024/04/23
---

- Complete interface redesign
    - New overall appearance inline with the SurrealDB aesthetic
    - Improved the general user experience of the app
    - Simplified the use of the sandbox
    - Replaced environments with connection templates
    - Added tooltips to all non-descriptive interactive elements
    - Improved view navigation with the new navigation sidebar
- New Functions view
    - Allows you to list, create, and update schema-based functions
    - Configure access permissions
    - Define function arguments
    - Full function body SurrealQL highlighting
- New ML Models view
    - Upload and list your SurrealML models
- New API Docs view
    - Personalised API documentation focused around your database
    - Code snippets for most languages supported by SurrealDB
    - Easy navigation using the table of contents
- Simplified sandbox
    - You no longer have to create sandbox connections manually
    - Built in support for loading official datasets
    - Sandboxes support all regular connection functionality
    - Quick sandbox reset button
- Introduced a command palette
    - Navigate and trigger any action with just your keyboard
    - Displays command keyboard shortcuts where available
    - Lists out latest 3 searches
- Saved query labeling
    - Organize your saved queries using one or more labels
    - Queries can be filtered on labels in the saved queries drawer
- Reworked live queries
    - Removed the Live view
    - Live queries can be sent directly from the Query view
    - Added a new “Live” result mode, which displays a live updating stream of messages
    - Live queries are automatically restarted when you re-run the query
    - You can mix live and non-live queries within the same request
- Improved query syntax highlighting
    - Now available in most places queries are displayed
    - Removed “Advanced editor” dialog from certain input fields, instead SurrealQL is now highlighted inline where applicable
- Help and support dialog
    - Provides an easy way to access the docs and submit an issue
- Integrated newsfeed
    - Accessible from the top right of the interface,
    - Provides an integrated newsfeed with useful updates about Surrealist and SurrealDB
- Connection templates
    - Replace the previous environment system
    - Can be applied when creating or updating a connection
    - Useful when working with multiple databases which share common connection details
    - A special convenient “Local database” template is made available when locally serving a database on Surrealist desktop
- Variable inference
    - Automatically analyses your query for variables and updates the variables panel
    - Will never remove existing variable definitions
- Sandbox dataset loading
    - Provides an easy way to experiment with SurrealQL by allowing you to load official datasets directly into your sandbox
- Query responses are now presented as SurrealQL values
    - You can use a new setting to toggle between JSON and SurrealQL mode
- Records can now be edited by pressing a record id in any data table
- Designer view tables can now be manually moved and positioned
- Re-added the ability to scale the interface in Surrealist Desktop
- Query history is now tracked per connection
- Switching between views now works more predictably