# About Revoke-Obfuscation's Data Science Approach

When we published our work on detecting obfuscated PowerShell through Revoke-Obfuscation, a big part of the effort was from a data science perspective. While it is relatively easy to find some examples of obfuscated PowerShell, determining whether an approach is likely to be successful in the real world requires much more than a few off-hand examples.

We primarily broke our investigation into five phases, which we are sharing here in the hope that the work we did can benefit future investigations into obfuscated PowerShell using alternative methods.

1) Prepare a PowerShell Corpus
2) Label items in the corpus as Obfuscated / Not Obfuscated
3) Identify a feature set for the PowerShell scripts
4) Run a Logistic Regression against this corpus given the identified features
5) Export the trained feature weights to incorporate into the Revoke-Obfuscation cmdlet itself

## Prepare a PowerShell Corpus

The PowerShell Corpus we collected represented every publicly-available PowerShell script we could reasonably find and collect. We harvested scripts from the PowerShell Gallery, the earlier Poshcode script repository, Github, Github gists, and Technet script center. It also includes the output from three popular obfuscation frameworks: Invoke-CradleCrafter, Invoke-Obfuscation, and ISESteroids.

It is important to note that this corpus is not targeted. It does not specifically represent a collection of PowerShell Malware, obfuscated PowerShell, developer's use of PowerShell, administrator's use of PowerShell, or anything else. While it contains examples of all of these, its purpose was to cast as wide a net as possible.

Uncompressed, this corpus is approximately 4GB
 - 408,665 scripts
 - 28,748 authors

You can download this corpus from http://aka.ms/PowerShellCorpus

## Label Items

As our goal for Revoke-Obfuscation was to detect obfuscated PowerShell, we spent a long time manually reviewing and labeling scripts to categorize them into the labels of "Obfuscated" and "Not Obfuscated". This is not the same thing as malicious / not malicious. There are many commands that are malicious but not obfuscated, and many commands that are obfuscated but not malicious (hello Code Golf!).

Our guiding principle during the labeling phase was this question: "Would we want this item surfaced for human review during an incident response?"

The PowerShell script we used to label scripts was 'Start-LabelSession.ps1', contained in this repository. With very minor modifications, it can be used to label any data set into a binary classification.

The labeled data is available as *-labeledData.csv in this repository. The 'Path' column in the CSV represents a relative path into the PowerShell Corpus. The 'Label' column is '1' if the script was obfuscated, '0' if not.

This labeled data resulted in:

 - 7,000 labeled scripts from human authors (1,600 labeled as obfuscated)
 - 4,000 intentionally obfuscated scripts via frameworks (all labeled as obfuscated)

And as an important reminder, this labeling was for obfuscation and not for malicious intent. Using these labels to detect "malicious PowerShell" would be an unwise approach.

## Identify Feature Set

The features identified and extracted during the modeling phase are included in the 'Checks' subdirectory of the Revoke-Obfuscation repository.

The 'Get-RvoFeatureVector' cmdlet in Revoke-Obfuscation is written to parse a PowerShell script and emit a feature vector for all of these identified features.

By running 'Get-RvoFeatureVector' on each script, merging its output with the label for that script, we were able to generate a master CSV of all labeled scripts, their feature vectors, and their label.

We have not included this resulting CSV in this part of the repository, but you can see how it is generated by reviewing 'Invoke-TrainingProcess.ps1'. Note that 'Invoke-TrainingProcess.ps1' is not intended to be run directly, it is more of a workbook that can be used to copy + paste required steps from.

## Run a Logistic Regression

The Logistic Regression training is implemented in the 'ModelTrainer' directory. Please see the source code in that directory for more information about the implementation. The script 'Invoke-TrainingProcess.ps1' in this repository contains more information about how to invoke it.

The implementation of this Logistic Regression was heavily based on the MSDN series, "[Gradient Descent Training using C#](https://docs.microsoft.com/en-us/archive/msdn-magazine/2015/march/test-run-gradient-descent-training-using-csharp)"

## Export the Trained Feature Weights

One of the last lines of output from ModelTrainer are the feature weights that best allow the Logistic Regression to fit the labeling of that data. ModelTrainer outputs this as a row of a CSV, which we then manually copied and pasted into the 'Measure-Vector' function in Revoke-Obfuscation.psm1. Measure-RvoObfuscation then uses this these weights against the feature vector to evaluate whether a target script is obfuscated or not.