# 開発陣からのお願いとデフォルトモデルの利用規約

- 2024-06-14: ライセンスとの整合性から「利用規約」を「お願い」に変更
- 2024-06-01: 初版

Style-Bert-VITS2を用いる際は、以下のお願いを守っていただけると幸いです。ただしモデルの利用規約以前の箇所はあくまで「お願い」であり、何の強制力はなく、Style-Bert-VITS2の利用規約ではありません。よって[リポジトリのライセンス](https://github.com/litagin02/Style-Bert-VITS2#license)とは矛盾せず、リポジトリの利用にあたっては常にリポジトリのライセンスのみが拘束力を持ちます。

## やってほしくないこと

以下の目的での利用はStyle-Bert-VITS2を使ってほしくありません。

- 法律に違反する目的
- 政治的な目的（本家Bert-VITS2で禁止されています）
- 他者を傷つける目的
- なりすまし・ディープフェイク作成目的

## 守ってほしいこと

- Style-Bert-VITS2を利用する際は、使用するモデルの利用規約・ライセンス必ず確認し、存在する場合はそれに従ってほしいです。
- またソースコードを利用する際は、[リポジトリのライセンス](https://github.com/litagin02/Style-Bert-VITS2#license)に従ってほしいです。

# モデルの利用規約・ライセンス

以下はデフォルトで付随しているモデルの利用規約・ライセンスです。このリポジトリ自体にはモデルは付随していないので、[リポジトリのライセンス](https://github.com/litagin02/Style-Bert-VITS2#license)とは関係がありません（なのでリポジトリライセンスとの矛盾は発生しません）。

## JVNVコーパス (jvnv-F1-jp, jvnv-F2-jp, jvnv-M1-jp, jvnv-M2-jp)

- [JVNVコーパス](https://sites.google.com/site/shinnosuketakamichi/research-topics/jvnv_corpus) のライセンスは[CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.ja)ですので、これを継承します。

## 小春音アミ (koharune-ami) / あみたろ (amitaro)

[あみたろの声素材工房様の規約](https://amitaro.net/voice/voice_rule/) と [あみたろのライブ配信音声・利用規約](https://amitaro.net/voice/livevoice/#index_id6) を全て守らなければなりません。特に、以下の事項を遵守してください（規約を守れば商用非商用問わず利用できます）。

### 禁止事項

- 年齢制限のある作品・用途への使用
- 新興宗教・政治・マルチ購などに深く関係する作品・用途
- 特定の団体や個人や国家を誹謗中傷する作品・用途
- 生成された音声を、あみたろ本人の声として扱うこと
- 生成された音声を、あみたろ以外の人の声として扱うこと

### クレジット表記

生成音声を公開する際は（媒体は問わない）、必ず分かりやすい場所に `あみたろの声素材工房 (https://amitaro.net/)` の声を元にした音声モデルを使用していることが分かるようなクレジット表記を記載してください。

クレジット表記例:
- `Style-BertVITS2モデル: 小春音アミ、あみたろの声素材工房 (https://amitaro.net/)`
- `Style-BertVITS2モデル: あみたろ、あみたろの声素材工房 (https://amitaro.net/)`

### モデルマージ

モデルマージに関しては、[あみたろの声素材工房のよくある質問への回答](https://amitaro.net/voice/faq/#index_id17)を遵守してください：
- 本モデルを別モデルとマージできるのは、その別モデル作成の際に学習に使われた声の権利者が許諾している場合に限る
- あみたろの声の特徴が残っている場合（マージの割合が25%以上の場合）は、その利用は[あみたろの声素材工房様の規約](https://amitaro.net/voice/voice_rule/)の範囲内に限定され、そのモデルに関してもこの規約が適応される