---
navigation:
  parent: crazyae2addons_index.md
  title: 自动建筑机编程语言
  icon: crazyae2addons:builder_pattern
categories:
   - Monitoring and Automation
item_ids:
   - crazyae2addons:builder_pattern
---

# 自动建筑机编程语言：完整教程

自动建筑机（AutoBuilder）语言可用于指示可编程的建筑机，让它执行移动、放置方块、破坏方块、等待等许多动作，且语言的语法简练、对宏友好。

---

## 程序结构

每则自动建筑机程序都可分为2或3个部分，各部分间使用管道符号（“|”）连接：

方块映射 | 宏 | 主程序

可以跳过宏部分：

方块映射 | 主程序

### 方块映射

定义可以使用的方块，并为其分配数字ID。语法为：

0(minecraft:stone),1(minecraft:dirt),2(minecraft:oak_planks)

每项的语法为：

\<数字\>(\<方块ID\>)

方块ID**不得**包含NBT数据，但允许包含方块状态，例如：

0(minecraft:oak_log\[axis=y\])

### 宏（可选）

宏是可重复使用的代码段，使用方括号定义：

\[宏名\](指令)

示例：

\[stairs\](P(0)D) \[floor\](3{P(1)E})

主程序中可由以下方式使用：

\[floor\]\[stairs\]

宏最多可扩展至**50个递归层**，这是为避免出现无限循环。

### 程序代码

指定实际的逻辑。可以直接使用指令，也可使用循环、宏、方块放置等。

---

## 指令参考文档

### 移动

| 代码 | 意义     |
| ---- | -------- |
| N    | 向北移动 |
| S    | 向南移动 |
| E    | 向东移动 |
| W    | 向西移动 |
| U    | 向上移动 |
| D    | 向下移动 |

每次移动都会将建筑机的游标向该方向移动**1格**。

---

### 放置方块

P(n)

放置方块映射中定义的方块。例如：

P(0)

会放置ID为0的方块，如minecraft:stone。

---

### 破坏方块

X

破坏当前位置的方块。

---

### 循环

3{ ... }

将大括号中间的内容重复**3遍**。

示例：

4{P(1)E}

放置方块1并向东移动，重复4次。

循环可嵌套。

示例：

2{3{P(1)W}U}

放置后向东移动，重复3次，然后向上移动。将此动作序列重复2次。

---

### 等待

Z(n)

等待n个Minecraft刻（20刻 = 1秒）。

示例：

P(0)Z(40)P(1)

放置方块0，等待2秒，放置方块1。

---

### 回到起点

R

令建筑机返回其启动位置。

---

### 宏

需在“宏”部分中定义，再在程序中通过以下形式使用：

[宏名]

宏中可以包含其他宏、循环等。

示例：

\[stairStep\](P(0)U E)

---

## 示例

### 1. 以一条线放置3格石头

0(minecraft:stone) | P(0)E P(0)E P(0)

功能一致，换用循环：

0(minecraft:stone) | 3{P(0)E}

---

### 2. 破坏后重建

0(minecraft:oak_planks) | X Z(20) P(0)

破坏方块，等待1秒，放置橡木木板。

---

### 3. 搭建阶梯

0(minecraft:oak_planks) | 5{P(0)U E}

向上方和东方搭建5次。

---

### 4. 返回原点

0(minecraft:stone) | 4{P(0)E} R

搭建向东延伸4格的小路，然后返回起点。

---

### 5. 使用宏

0(minecraft:stone),1(minecraft:dirt) | \[line\](3{P(0)E}) \[top\](U \[line\]) | \[line\]\[top\]\[line\]

- 定义“线”/“line”，也即向东3格的石头小路。
- 定义“上方”/“top”，也即在上方1格处搭建同样的“线”。

---

## 错误处理

本语言是一种严格语言：

- 在P(n)中使用方块映射内不存在的ID → 错误。
- 括号（{}、()、[]）错配 → 错误。
- 宏无限递归 → 展开50次后产生错误。