/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks.entities;

import cn.foggyhillside.festival_delicacies.blocks.StoveBlock;
import cn.foggyhillside.festival_delicacies.blocks.screen.StoveMenu;
import cn.foggyhillside.festival_delicacies.recipe.StoveRecipe;
import cn.foggyhillside.festival_delicacies.registry.ModBlockEntities;
import cn.foggyhillside.festival_delicacies.tag.ModTags;
import cn.foggyhillside.festival_delicacies.util.RecipeUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveEntity
extends BlockEntity
implements MenuProvider {
    protected final ContainerData data;
    private int progress = 0;
    private int maxprogress;
    private LazyOptional<IItemHandler> handlerLazyOptional = LazyOptional.empty();
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            StoveEntity.this.m_6596_();
        }
    };

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlerLazyOptional.cast();
        }
        return super.getCapability(cap);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.festival_delicacies.stove");
    }

    public void onLoad() {
        super.onLoad();
        this.handlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handlerLazyOptional.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        nbt.m_128405_("stove.progress", this.progress);
        nbt.m_128405_("stove_maxprogress", this.maxprogress);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("stove.progress");
        this.maxprogress = nbt.m_128451_("stove_maxprogress");
        super.m_142466_(nbt);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemStackHandler.getSlots());
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemStackHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StoveEntity entity) {
        Optional recipe;
        if (level.f_46443_) {
            return;
        }
        boolean isPot = level.m_8055_(entity.m_58899_().m_7494_()).m_204336_(ModTags.IS_POT);
        if (!isPot) {
            if (entity.itemStackHandler.getStackInSlot(2) != ItemStack.f_41583_) {
                StoveEntity.spawnItem(entity, level, 2, entity.itemStackHandler.getStackInSlot(2));
                entity.itemStackHandler.setStackInSlot(2, ItemStack.f_41583_);
            }
            if (entity.itemStackHandler.getStackInSlot(5) != ItemStack.f_41583_) {
                StoveEntity.spawnItem(entity, level, 5, entity.itemStackHandler.getStackInSlot(5));
                entity.itemStackHandler.setStackInSlot(5, ItemStack.f_41583_);
            }
            if (entity.itemStackHandler.getStackInSlot(6) != ItemStack.f_41583_) {
                StoveEntity.spawnItem(entity, level, 6, entity.itemStackHandler.getStackInSlot(6));
                entity.itemStackHandler.setStackInSlot(6, ItemStack.f_41583_);
            }
            if (entity.itemStackHandler.getStackInSlot(7) != ItemStack.f_41583_) {
                StoveEntity.spawnItem(entity, level, 7, entity.itemStackHandler.getStackInSlot(7));
                entity.itemStackHandler.setStackInSlot(7, ItemStack.f_41583_);
            }
            if (entity.itemStackHandler.getStackInSlot(8) != ItemStack.f_41583_) {
                StoveEntity.spawnItem(entity, level, 8, entity.itemStackHandler.getStackInSlot(8));
                entity.itemStackHandler.setStackInSlot(8, ItemStack.f_41583_);
            }
        }
        if (StoveEntity.hasRecipe(entity, recipe = level.m_7465_().m_44015_((RecipeType)StoveRecipe.Type.INSTANCE, (Container)StoveEntity.getInventory(entity), level)) && StoveEntity.canCook(isPot, entity, state, recipe)) {
            ++entity.progress;
            entity.maxprogress = ((StoveRecipe)recipe.get()).getCookTime();
            StoveEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (entity.progress >= ((StoveRecipe)recipe.get()).getCookTime()) {
                StoveEntity.craftItem(level, entity, recipe);
            }
        } else {
            entity.resetProgress();
            StoveEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private static boolean canCook(Boolean isPot, StoveEntity entity, BlockState state, Optional<StoveRecipe> recipe) {
        boolean isLit = (Boolean)state.m_61143_((Property)StoveBlock.LIT);
        if (recipe.get().getNeedPot().booleanValue()) {
            return isPot != false && isLit && StoveEntity.canOutput(entity, recipe);
        }
        return isLit && StoveEntity.canOutput(entity, recipe);
    }

    private static boolean canOutput(StoveEntity entity, Optional<StoveRecipe> recipe) {
        return entity.itemStackHandler.getStackInSlot(10) == ItemStack.f_41583_ || entity.itemStackHandler.getStackInSlot(10).m_41720_() == RecipeUtils.getResultItem(recipe.get()).m_41720_() && entity.itemStackHandler.getStackInSlot(10).m_41613_() < RecipeUtils.getResultItem(recipe.get()).m_41720_().m_41459_();
    }

    private static boolean hasRecipe(StoveEntity entity, Optional<StoveRecipe> recipe) {
        return recipe.isPresent();
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static SimpleContainer getInventory(StoveEntity entity) {
        int h = 0;
        SimpleContainer inventory = new SimpleContainer(entity.itemStackHandler.getSlots());
        for (int i = 0; i < entity.itemStackHandler.getSlots(); ++i) {
            if (i < 9 && entity.itemStackHandler.getStackInSlot(i) != ItemStack.f_41583_) {
                inventory.m_6836_(h, entity.itemStackHandler.getStackInSlot(i));
                ++h;
            } else if (i < 9) {
                inventory.m_6836_(8 - (i - h), entity.itemStackHandler.getStackInSlot(i));
            }
            if (i != 9 && i != 10) continue;
            inventory.m_6836_(i, entity.itemStackHandler.getStackInSlot(i));
        }
        return inventory;
    }

    private static void craftItem(Level level, StoveEntity entity, Optional<StoveRecipe> recipe) {
        if (StoveEntity.hasRecipe(entity, recipe)) {
            for (int i = 0; i < 10; ++i) {
                if (entity.itemStackHandler.getStackInSlot(i) == ItemStack.f_41583_) continue;
                if (entity.itemStackHandler.getStackInSlot(i).hasCraftingRemainingItem()) {
                    StoveEntity.spawnItem(entity, level, i, entity.itemStackHandler.getStackInSlot(i).getCraftingRemainingItem());
                }
                entity.itemStackHandler.extractItem(i, 1, false);
            }
            entity.itemStackHandler.setStackInSlot(10, new ItemStack((ItemLike)recipe.get().m_8043_(level.m_9598_()).m_41720_(), entity.itemStackHandler.getStackInSlot(10).m_41613_() + RecipeUtils.getResultItem(recipe.get()).m_41613_()));
            entity.resetProgress();
        }
    }

    private static void spawnItem(StoveEntity entity, Level level, int i, ItemStack itemStack) {
        Direction direction = ((Direction)entity.m_58900_().m_61143_((Property)StoveBlock.FACING)).m_122428_();
        double x = (double)entity.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
        double y = (double)entity.f_58858_.m_123342_() + 0.7;
        double z = (double)entity.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
        ItemEntity itemEntity = new ItemEntity(level, x, y, z, itemStack);
        itemEntity.m_20334_((double)((float)direction.m_122429_() * 0.08f), 0.75, (double)((float)direction.m_122431_() * 0.08f));
        level.m_7967_((Entity)itemEntity);
    }

    public StoveEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STOVE.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> StoveEntity.this.progress;
                    case 1 -> StoveEntity.this.maxprogress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        StoveEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        StoveEntity.this.maxprogress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new StoveMenu(id, inventory, this, this.data);
    }
}

