/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.content.block;

import io.github.jasonsimpart.createdelightcore.CDConfig;
import io.github.jasonsimpart.createdelightcore.content.block.LunaSoilBlock;
import io.github.jasonsimpart.createdelightcore.registry.CDBlocks;
import javax.annotation.Nullable;
import net.jadenxgamer.netherexp.registry.fluid.JNEFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeHooks;
import vectorwing.farmersdelight.common.block.RichSoilFarmlandBlock;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class LunaSoilFarmlandBlock
extends RichSoilFarmlandBlock {
    public LunaSoilFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean hasMoistSource(LevelReader level, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!level.m_6425_(nearbyPos).m_192917_((Fluid)JNEFluids.ECTOPLASM_SOURCE.get())) continue;
            return true;
        }
        return false;
    }

    public static void turnToLunaSoil(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, LunaSoilFarmlandBlock.m_49897_((BlockState)state, (BlockState)((LunaSoilBlock)((Object)CDBlocks.LUNA_SOIL.get())).m_49966_(), (LevelAccessor)level, (BlockPos)pos));
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)state));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        return super.m_7898_(state, level, pos) || aboveState.m_60734_() instanceof StemGrownBlock;
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.m_60713_((Block)CDBlocks.LUNA_SOIL_FARMLAND.get())) {
            return (Integer)state.m_61143_((Property)f_53243_) > 0;
        }
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            LunaSoilFarmlandBlock.turnToLunaSoil(null, state, (Level)level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.m_61143_((Property)f_53243_);
        if (!LunaSoilFarmlandBlock.hasMoistSource((LevelReader)level, pos)) {
            if (moisture > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture - 1)), 2);
            }
        } else if (moisture < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        } else if (moisture == 7) {
            if (CDConfig.lunaSoilBoostChance == 0.0) {
                return;
            }
            if (!level.m_46472_().m_135782_().m_135827_().equals("ad_astra")) {
                return;
            }
            BlockState aboveState = level.m_8055_(pos.m_7494_());
            Block aboveBlock = aboveState.m_60734_();
            if (aboveState.m_204336_(ModTags.UNAFFECTED_BY_RICH_SOIL) || aboveBlock instanceof TallFlowerBlock) {
                return;
            }
            if (aboveBlock instanceof BonemealableBlock) {
                BonemealableBlock growable = (BonemealableBlock)aboveBlock;
                if ((double)MathUtils.RAND.nextFloat() <= CDConfig.lunaSoilBoostChance && growable.m_7370_((LevelReader)level, pos.m_7494_(), aboveState, false) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos.m_7494_(), (BlockState)aboveState, (boolean)true)) {
                    growable.m_214148_(level, level.f_46441_, pos.m_7494_(), aboveState);
                    if (!level.f_46443_) {
                        level.m_46796_(2005, pos.m_7494_(), 0);
                    }
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos.m_7494_(), (BlockState)aboveState);
                }
            }
        }
    }
}

