/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntoolcmd;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public final class HelpDocument {
    private HelpDocument() {
    }

    public static void printHelp(LogUtils logger) {
        ClassLoader classLoader = HelpDocument.class.getClassLoader();
        if (classLoader == null) {
            return;
        }
        String page = "help.txt";
        try (InputStream inputStream = classLoader.getResourceAsStream(page);){
            if (inputStream == null) {
                return;
            }
            byte[] helpData = FileUtils.read(inputStream);
            String helpStr = new String(helpData, StandardCharsets.UTF_8);
            logger.info(helpStr);
        }
        catch (IOException ioe) {
            logger.debug(ioe.getMessage(), ioe);
            CustomException.throwException(ERROR.READ_FILE_ERROR, SignToolErrMsg.FILE_READ_FAILED.toString(page));
        }
    }
}

