/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.error.HapFormatException;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.zip.ZipDataInput;
import com.ohos.hapsigntool.zip.ZipFileInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ZipUtils {
    private static final int ZIP_EOCD_SEGMENT_MIN_SIZE = 22;
    private static final int ZIP_EOCD_SEGMENT_FLAG = 101010256;
    private static final int ZIP_CENTRAL_DIR_COUNT_OFFSET_IN_EOCD = 10;
    private static final int ZIP_CENTRAL_DIR_SIZE_OFFSET_IN_EOCD = 12;
    private static final int ZIP_CENTRAL_DIR_OFFSET_IN_EOCD = 16;
    private static final int ZIP_EOCD_COMMENT_LENGTH_OFFSET = 20;
    private static final int ZIP64_EOCD_LOCATOR_SIZE = 20;
    private static final int ZIP64_EOCD_LOCATOR_SIG = 117853008;
    private static final int UINT16_MAX_VALUE = 65535;
    private static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;
    private static final int ZIP_DATA_SIZE = 4;

    private ZipUtils() {
    }

    public static int findEocdInSearchBuffer(ByteBuffer searchBuffer) {
        ZipUtils.checkBufferIsLittleEndian(searchBuffer);
        int searchBufferSize = searchBuffer.capacity();
        if (searchBufferSize < 22) {
            return -1;
        }
        for (int currentOffset = searchBufferSize - 22; currentOffset >= 0; --currentOffset) {
            int expectedCommentLength;
            int commentLength;
            if (searchBuffer.getInt(currentOffset) != 101010256 || (commentLength = ZipUtils.getUInt16FromBuffer(searchBuffer, currentOffset + 20)) != (expectedCommentLength = searchBufferSize - 22 - currentOffset)) continue;
            return currentOffset;
        }
        return -1;
    }

    public static boolean checkZip64EoCDLocatorIsPresent(ZipDataInput zip, long zipEocdOffset) throws IOException {
        long locatorPos = zipEocdOffset - 20L;
        if (locatorPos < 0L) {
            return false;
        }
        ByteBuffer byteBuffer = zip.createByteBuffer(locatorPos, 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt() == 117853008;
    }

    public static long getCentralDirectoryOffset(ByteBuffer eocd) {
        ZipUtils.checkBufferIsLittleEndian(eocd);
        return ZipUtils.getUInt32FromBuffer(eocd, eocd.position() + 16);
    }

    public static void setCentralDirectoryOffset(ByteBuffer eocd, long offset) {
        ZipUtils.checkBufferIsLittleEndian(eocd);
        ZipUtils.setUInt32ToBuffer(eocd, eocd.position() + 16, offset);
    }

    public static long getCentralDirectorySize(ByteBuffer eocd) {
        ZipUtils.checkBufferIsLittleEndian(eocd);
        return ZipUtils.getUInt32FromBuffer(eocd, eocd.position() + 12);
    }

    public static int getCentralDirectoryCount(ByteBuffer eocd) {
        ZipUtils.checkBufferIsLittleEndian(eocd);
        return ZipUtils.getUInt16FromBuffer(eocd, eocd.position() + 10);
    }

    private static void checkBufferIsLittleEndian(ByteBuffer buffer) {
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return;
        }
        throw new IllegalArgumentException("ByteBuffer is not little endian");
    }

    static int getUInt16FromBuffer(ByteBuffer buffer, int offset) {
        return buffer.getShort(offset) & 0xFFFF;
    }

    static long getUInt32FromBuffer(ByteBuffer buffer, int offset) {
        return (long)buffer.getInt(offset) & 0xFFFFFFFFL;
    }

    private static void setUInt32ToBuffer(ByteBuffer buffer, int offset, long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("uint32 value of out range: " + value);
        }
        buffer.putInt(buffer.position() + offset, (int)value);
    }

    public static ZipFileInfo findZipInfo(ZipDataInput in) throws IOException, HapFormatException {
        Pair<Long, ByteBuffer> eocdOffsetAndBuffer = ZipUtils.findEocdInHap(in);
        if (eocdOffsetAndBuffer == null) {
            throw new HapFormatException(SignToolErrMsg.ZIP_FORMAT_FAILED.toString("ZIP End of Central Directory not found"));
        }
        long eocdOffset = eocdOffsetAndBuffer.getFirst();
        ByteBuffer eocdBuffer = eocdOffsetAndBuffer.getSecond().order(ByteOrder.LITTLE_ENDIAN);
        long centralDirectoryStartOffset = ZipUtils.getCentralDirectoryOffset(eocdBuffer);
        if (centralDirectoryStartOffset > eocdOffset) {
            throw new HapFormatException(SignToolErrMsg.ZIP_FORMAT_FAILED.toString("ZIP Central Directory start offset(" + centralDirectoryStartOffset + ") larger than ZIP End of Central Directory offset(" + eocdOffset + ")"));
        }
        long centralDirectorySizeLong = ZipUtils.getCentralDirectorySize(eocdBuffer);
        if (centralDirectorySizeLong > Integer.MAX_VALUE) {
            throw new HapFormatException(SignToolErrMsg.ZIP_FORMAT_FAILED.toString("ZIP Central Directory out of range: " + centralDirectorySizeLong));
        }
        int centralDirectorySize = (int)centralDirectorySizeLong;
        long centralDirectoryEndOffset = centralDirectoryStartOffset + centralDirectorySizeLong;
        if (centralDirectoryEndOffset != eocdOffset) {
            throw new HapFormatException(SignToolErrMsg.ZIP_FORMAT_FAILED.toString("ZIP Central Directory end offset(" + centralDirectoryEndOffset + ")  different from ZIP End of Central Directory offset(" + eocdOffset + ")"));
        }
        int centralDirectoryCount = ZipUtils.getCentralDirectoryCount(eocdBuffer);
        return new ZipFileInfo(centralDirectoryStartOffset, centralDirectorySize, centralDirectoryCount, eocdOffset, eocdBuffer);
    }

    private static Pair<Long, ByteBuffer> findEocdInHap(ZipDataInput in) throws IOException {
        Pair<Long, ByteBuffer> eocdInHap = ZipUtils.findEocdInHap(in, 0);
        if (eocdInHap != null) {
            return eocdInHap;
        }
        return ZipUtils.findEocdInHap(in, 65535);
    }

    private static Pair<Long, ByteBuffer> findEocdInHap(ZipDataInput zip, int maxCommentSize) throws IOException {
        if (maxCommentSize < 0 || maxCommentSize > 65535) {
            throw new IllegalArgumentException("maxCommentSize: " + maxCommentSize);
        }
        long fileSize = zip.size();
        if (fileSize < 22L) {
            throw new IllegalArgumentException("file length " + fileSize + " is too smaller");
        }
        int finalMaxCommentSize = (int)Math.min((long)maxCommentSize, fileSize - 22L);
        int searchBufferSize = finalMaxCommentSize + 22;
        long bufferOffsetInFile = fileSize - (long)searchBufferSize;
        ByteBuffer searchEocdBuffer = zip.createByteBuffer(bufferOffsetInFile, searchBufferSize);
        searchEocdBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int eocdOffsetInSearchBuffer = ZipUtils.findEocdInSearchBuffer(searchEocdBuffer);
        if (eocdOffsetInSearchBuffer == -1) {
            return null;
        }
        searchEocdBuffer.position(eocdOffsetInSearchBuffer);
        ByteBuffer eocdBuffer = searchEocdBuffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        return Pair.create(bufferOffsetInFile + (long)eocdOffsetInSearchBuffer, eocdBuffer);
    }
}

