/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import java.nio.ByteBuffer;

public class UnsignedDecimalUtil {
    public static final long MAX_UNSIGNED_INT_VALUE = 0xFFFFFFFFL;
    public static final int MAX_UNSIGNED_SHORT_VALUE = 65535;
    private static final int BIT_SIZE = 8;
    private static final int DOUBLE_BIT_SIZE = 16;
    private static final int TRIPLE_BIT_SIZE = 24;

    public static long getUnsignedInt(ByteBuffer bf) {
        return (long)bf.getInt() & 0xFFFFFFFFL;
    }

    public static int getUnsignedShort(ByteBuffer bf) {
        return bf.getShort() & 0xFFFF;
    }

    public static void setUnsignedInt(ByteBuffer bf, long value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
        bf.put(bytes);
    }

    public static void setUnsignedShort(ByteBuffer bf, int value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        bf.put(bytes);
    }
}

