/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.zip.ZipDataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessFileZipDataOutput
implements ZipDataOutput {
    private final RandomAccessFile file;
    private final FileChannel fileChannel;
    private long position;

    public RandomAccessFileZipDataOutput(RandomAccessFile file) {
        this(file, 0L);
    }

    public RandomAccessFileZipDataOutput(RandomAccessFile file, long startPosition) {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        if (startPosition < 0L) {
            throw new IllegalArgumentException("Invalid start position: " + startPosition);
        }
        this.file = file;
        this.fileChannel = file.getChannel();
        this.position = startPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (offset > buffer.length) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") > buffer length(" + buffer.length + ")");
        }
        if (length == 0) {
            return;
        }
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.file.seek(this.position);
            this.file.write(buffer, offset, length);
            this.position += (long)length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer buffer) throws IOException {
        int length = buffer.remaining();
        if (length == 0) {
            return;
        }
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.file.seek(this.position);
            while (buffer.hasRemaining()) {
                this.fileChannel.write(buffer);
            }
            this.position += (long)length;
        }
    }
}

