/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.zip.ZipDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class MessageDigestZipDataOutput
implements ZipDataOutput {
    private final MessageDigest[] messageDigests;

    public MessageDigestZipDataOutput(MessageDigest[] digests) {
        this.messageDigests = digests;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        for (MessageDigest messageDigest : this.messageDigests) {
            messageDigest.update(buffer, offset, length);
        }
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        int position = buffer.position();
        for (MessageDigest messageDigest : this.messageDigests) {
            buffer.position(position);
            messageDigest.update(buffer);
        }
    }
}

