/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.error.ZipException;
import com.ohos.hapsigntool.zip.UnsignedDecimalUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class CentralDirectory {
    public static final int CD_LENGTH = 46;
    public static final int SIGNATURE = 33639248;
    private short version;
    private short versionExtra;
    private short flag;
    private short method;
    private short lastTime;
    private short lastDate;
    private int crc32;
    private long compressedSize;
    private long unCompressedSize;
    private int fileNameLength;
    private int extraLength;
    private int commentLength;
    private int diskNumStart;
    private short internalFile;
    private int externalFile;
    private long offset;
    private String fileName;
    private byte[] extraData;
    private byte[] comment;
    private int length;

    public void updateLength() {
        this.length = 46 + this.fileNameLength + this.extraLength + this.commentLength;
    }

    public static CentralDirectory getCentralDirectory(ByteBuffer bf) throws ZipException {
        CentralDirectory cd = new CentralDirectory();
        if (bf.getInt() != 33639248) {
            throw new ZipException("find zip central directory failed");
        }
        cd.setVersion(bf.getShort());
        cd.setVersionExtra(bf.getShort());
        cd.setFlag(bf.getShort());
        cd.setMethod(bf.getShort());
        cd.setLastTime(bf.getShort());
        cd.setLastDate(bf.getShort());
        cd.setCrc32(bf.getInt());
        cd.setCompressedSize(UnsignedDecimalUtil.getUnsignedInt(bf));
        cd.setUnCompressedSize(UnsignedDecimalUtil.getUnsignedInt(bf));
        cd.setFileNameLength(UnsignedDecimalUtil.getUnsignedShort(bf));
        cd.setExtraLength(UnsignedDecimalUtil.getUnsignedShort(bf));
        cd.setCommentLength(UnsignedDecimalUtil.getUnsignedShort(bf));
        cd.setDiskNumStart(UnsignedDecimalUtil.getUnsignedShort(bf));
        cd.setInternalFile(bf.getShort());
        cd.setExternalFile(bf.getInt());
        cd.setOffset(UnsignedDecimalUtil.getUnsignedInt(bf));
        if (cd.getFileNameLength() > 0) {
            byte[] readFileName = new byte[cd.getFileNameLength()];
            bf.get(readFileName);
            cd.setFileName(new String(readFileName, StandardCharsets.UTF_8));
        }
        if (cd.getExtraLength() > 0) {
            byte[] extra = new byte[cd.getExtraLength()];
            bf.get(extra);
            cd.setExtraData(extra);
        }
        if (cd.getCommentLength() > 0) {
            byte[] readComment = new byte[cd.getCommentLength()];
            bf.get(readComment);
            cd.setComment(readComment);
        }
        cd.updateLength();
        return cd;
    }

    public byte[] toBytes() {
        ByteBuffer bf = ByteBuffer.allocate(this.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(33639248);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.version);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.versionExtra);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.flag);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.method);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.lastTime);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.lastDate);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.crc32);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.compressedSize);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.unCompressedSize);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.fileNameLength);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.extraLength);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.commentLength);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.diskNumStart);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.internalFile);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.externalFile);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.offset);
        if (this.fileNameLength > 0) {
            bf.put(this.fileName.getBytes(StandardCharsets.UTF_8));
        }
        if (this.extraLength > 0) {
            bf.put(this.extraData);
        }
        if (this.commentLength > 0) {
            bf.put(this.extraData);
        }
        return bf.array();
    }

    public static int getCdLength() {
        return 46;
    }

    public static int getSIGNATURE() {
        return 33639248;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getVersionExtra() {
        return this.versionExtra;
    }

    public void setVersionExtra(short versionExtra) {
        this.versionExtra = versionExtra;
    }

    public short getFlag() {
        return this.flag;
    }

    public void setFlag(short flag) {
        this.flag = flag;
    }

    public short getMethod() {
        return this.method;
    }

    public void setMethod(short method) {
        this.method = method;
    }

    public short getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(short lastTime) {
        this.lastTime = lastTime;
    }

    public short getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(short lastDate) {
        this.lastDate = lastDate;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public void setCrc32(int crc32) {
        this.crc32 = crc32;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    public long getUnCompressedSize() {
        return this.unCompressedSize;
    }

    public void setUnCompressedSize(long unCompressedSize) {
        this.unCompressedSize = unCompressedSize;
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength = fileNameLength;
    }

    public int getExtraLength() {
        return this.extraLength;
    }

    public void setExtraLength(int extraLength) {
        this.extraLength = extraLength;
    }

    public int getCommentLength() {
        return this.commentLength;
    }

    public void setCommentLength(int commentLength) {
        this.commentLength = commentLength;
    }

    public int getDiskNumStart() {
        return this.diskNumStart;
    }

    public void setDiskNumStart(int diskNumStart) {
        this.diskNumStart = diskNumStart;
    }

    public short getInternalFile() {
        return this.internalFile;
    }

    public void setInternalFile(short internalFile) {
        this.internalFile = internalFile;
    }

    public int getExternalFile() {
        return this.externalFile;
    }

    public void setExternalFile(int externalFile) {
        this.externalFile = externalFile;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    public void setExtraData(byte[] extraData) {
        this.extraData = extraData;
    }

    public byte[] getComment() {
        return this.comment;
    }

    public void setComment(byte[] comment) {
        this.comment = comment;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

