/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.utils;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.ValidateUtils;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.util.encoders.Base64;

public final class KeyPairTools {
    public static final String RSA = "RSA";
    public static final String ECC = "EC";
    public static final String ECC_INPUT = "ECC";
    public static final int RSA_2048 = 2048;
    public static final int RSA_3072 = 3072;
    public static final int RSA_4096 = 4096;
    public static final int NIST_P_256 = 256;
    public static final int NIST_P_384 = 384;
    private static final LogUtils LOGGER = new LogUtils(KeyPairTools.class);

    private KeyPairTools() {
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        String alg;
        if (algorithm == null) {
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, SignToolErrMsg.ALGORITHM_NOT_SUPPORT.toString("Not support algorithm: null"));
        }
        if (ECC_INPUT.equalsIgnoreCase(alg = algorithm)) {
            alg = ECC;
        }
        if (RSA.equalsIgnoreCase(alg)) {
            ValidateUtils.throwIfNotMatches(keySize == 2048 || keySize == 3072 || keySize == 4096, ERROR.NOT_SUPPORT_ERROR, SignToolErrMsg.ALGORITHM_NOT_SUPPORT.toString("Algorithm 'RSA' not support size: " + keySize));
        } else if (ECC.equalsIgnoreCase(alg)) {
            ValidateUtils.throwIfNotMatches(keySize == 256 || keySize == 384, ERROR.NOT_SUPPORT_ERROR, SignToolErrMsg.ALGORITHM_NOT_SUPPORT.toString("Algorithm 'ECC' not support size: " + keySize));
        } else {
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, SignToolErrMsg.ALGORITHM_NOT_SUPPORT.toString("Not support algorithm: " + alg));
        }
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(alg);
            keyPairGenerator.initialize(keySize);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.debug(e.getMessage(), e);
            CustomException.throwException(ERROR.NOT_SUPPORT_ERROR, SignToolErrMsg.NO_SUCH_SIGNATURE.toString(e.getMessage()));
            return null;
        }
    }

    public static String key2String(Key key) {
        return Base64.toBase64String(key.getEncoded());
    }

    public static PublicKey stringToPublicKey(String algorithm, String keyString) {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.decode(keyString));
        PublicKey result = null;
        try {
            result = KeyFactory.getInstance(algorithm).generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            LOGGER.debug(exception.getMessage(), exception);
            CustomException.throwException(ERROR.ACCESS_ERROR, SignToolErrMsg.NO_SUCH_SIGNATURE.toString(exception.getMessage()));
        }
        return result;
    }

    public static PrivateKey stringToPrivateKey(String algorithm, String keyString) {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Base64.decode(keyString));
        PrivateKey result = null;
        try {
            result = KeyFactory.getInstance(algorithm).generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            LOGGER.debug(exception.getMessage(), exception);
            CustomException.throwException(ERROR.ACCESS_ERROR, SignToolErrMsg.NO_SUCH_SIGNATURE.toString(exception.getMessage()));
        }
        return result;
    }
}

