/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.profile.model;

import com.google.gson.annotations.SerializedName;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.profile.model.Acls;
import com.ohos.hapsigntool.profile.model.BundleInfo;
import com.ohos.hapsigntool.profile.model.DebugInfo;
import com.ohos.hapsigntool.profile.model.Permissions;
import com.ohos.hapsigntool.profile.model.Validity;
import com.ohos.hapsigntool.utils.ValidateUtils;

public class Provision {
    public static final String DEBUG = "debug";
    public static final String RELEASE = "release";
    public static final String HOS_SYSTEM_APP = "hos_system_app";
    public static final String HOS_NORMAL_APP = "hos_normal_app";
    public static final String NORMAL = "normal";
    public static final String SYSTEM_BASIC = "system_basic";
    public static final String SYSTEM_CORE = "system_core";
    public static final String APP_GALLERY = "app_gallery";
    public static final String ENTERPRISE = "enterprise";
    public static final String OS_INTEGRATION = "os_integration";
    public static final int NUM_ONE_HUNDRED = 100;
    public static final String NEWLINE_CHARACTER = System.lineSeparator();
    @SerializedName(value="version-code")
    private Integer versionCode;
    @SerializedName(value="version-name")
    private String versionName;
    @SerializedName(value="uuid")
    private String uuid;
    @SerializedName(value="type")
    private String type;
    @SerializedName(value="app-distribution-type")
    private String appDistributionType;
    @SerializedName(value="validity")
    private Validity validity;
    @SerializedName(value="bundle-info")
    private BundleInfo bundleInfo;
    @SerializedName(value="acls")
    private Acls acls;
    @SerializedName(value="permissions")
    private Permissions permissions;
    @SerializedName(value="debug-info")
    private DebugInfo debuginfo;
    @SerializedName(value="issuer")
    private String issuer;

    public static boolean isBuildTypeValid(String buildType) {
        return DEBUG.equals(buildType) || RELEASE.equals(buildType);
    }

    public static boolean isBuildTypeRelease(String buildType) {
        return RELEASE.equals(buildType);
    }

    public static boolean isAppDistTypeValid(String appDistType) {
        return APP_GALLERY.equals(appDistType) || ENTERPRISE.equals(appDistType) || OS_INTEGRATION.equals(appDistType);
    }

    public static void enforceValid(Provision provision) {
        ValidateUtils.throwIfMatches(provision.type == null || !Provision.isBuildTypeValid(provision.type), ERROR.SIGN_ERROR, SignToolErrMsg.SIGNATURE_FAILED.toString("Require build type must be debug or release, current is :" + provision.type));
        ValidateUtils.throwIfMatches(provision.bundleInfo == null, ERROR.SIGN_ERROR, SignToolErrMsg.SIGNATURE_FAILED.toString("Require bundleInfo in provision!"));
        provision.bundleInfo.enforceValid(provision.type);
    }

    public Integer getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(Integer versionCode) {
        this.versionCode = versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAppDistributionType() {
        return this.appDistributionType;
    }

    public void setAppDistributionType(String appDistributionType) {
        this.appDistributionType = appDistributionType;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public void setValidity(Validity validity) {
        this.validity = validity;
    }

    public BundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    public void setBundleInfo(BundleInfo bundleInfo) {
        this.bundleInfo = bundleInfo;
    }

    public Acls getAcls() {
        return this.acls;
    }

    public void setAcls(Acls acls) {
        this.acls = acls;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public DebugInfo getDebuginfo() {
        return this.debuginfo;
    }

    public void setDebuginfo(DebugInfo debuginfo) {
        this.debuginfo = debuginfo;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String toString() {
        return NEWLINE_CHARACTER + "version-code:" + this.versionCode + NEWLINE_CHARACTER + "version-name:" + this.versionCode + NEWLINE_CHARACTER + "uuid:" + this.uuid + NEWLINE_CHARACTER + "type:" + this.type + NEWLINE_CHARACTER + "app-distribution-type:" + this.appDistributionType + NEWLINE_CHARACTER + "validity:" + NEWLINE_CHARACTER + "\t not-before:" + this.getValidity().getNotBefore() + NEWLINE_CHARACTER + "\t not-after:" + this.getValidity().getNotAfter() + NEWLINE_CHARACTER + "bundle-info" + NEWLINE_CHARACTER + "\t developer-id:" + this.getBundleInfo().getDeveloperId() + NEWLINE_CHARACTER + "\t development-certificate:" + this.getBundleInfo().getDevelopmentCertificate() + NEWLINE_CHARACTER + "\t distribution-certificate:" + this.getBundleInfo().getDistributionCertificate() + NEWLINE_CHARACTER + "\t bundle-name:" + this.getBundleInfo().getBundleName() + NEWLINE_CHARACTER + "\t apl:" + this.getBundleInfo().getApl() + NEWLINE_CHARACTER + "\t app-feature:" + this.getBundleInfo().getAppFeature() + NEWLINE_CHARACTER + "acls:" + NEWLINE_CHARACTER + "\t allowed-acls:" + this.getAcls().getAllowedAcls() + NEWLINE_CHARACTER + "permissions:" + NEWLINE_CHARACTER + "\t restricted-permissions:" + this.getPermissions().getRestrictedPermissions() + NEWLINE_CHARACTER + "\t restricted-capabilities:" + this.getPermissions().getRestrictedCapabilities() + NEWLINE_CHARACTER + "debug-info" + NEWLINE_CHARACTER + "\t device-id-type:" + this.getDebuginfo().getDeviceIdType() + NEWLINE_CHARACTER + "\t device-ids:" + this.getDebuginfo().getDeviceIds() + NEWLINE_CHARACTER + "issuer:" + this.getIssuer();
    }
}

