/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.profile.model;

import com.google.gson.annotations.SerializedName;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.profile.model.Provision;
import com.ohos.hapsigntool.utils.ValidateUtils;

public class BundleInfo {
    @SerializedName(value="developer-id")
    private String developerId;
    @SerializedName(value="development-certificate")
    private String developmentCertificate;
    @SerializedName(value="distribution-certificate")
    private String distributionCertificate;
    @SerializedName(value="bundle-name")
    private String bundleName;
    @SerializedName(value="apl")
    private String apl;
    @SerializedName(value="app-feature")
    private String appFeature;

    public String getDeveloperId() {
        return this.developerId;
    }

    public void setDeveloperId(String developerId) {
        this.developerId = developerId;
    }

    public String getDevelopmentCertificate() {
        return this.developmentCertificate;
    }

    public void setDevelopmentCertificate(String developmentCertificate) {
        this.developmentCertificate = developmentCertificate;
    }

    public String getDistributionCertificate() {
        return this.distributionCertificate;
    }

    public void setDistributionCertificate(String distributionCertificate) {
        this.distributionCertificate = distributionCertificate;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getApl() {
        return this.apl;
    }

    public void setApl(String apl) {
        this.apl = apl;
    }

    public String getAppFeature() {
        return this.appFeature;
    }

    public void setAppFeature(String appFeature) {
        this.appFeature = appFeature;
    }

    public void enforceValid(String buildType) {
        if (Provision.isBuildTypeRelease(buildType)) {
            ValidateUtils.throwIfMatches(this.distributionCertificate == null, ERROR.SIGN_ERROR, SignToolErrMsg.SIGNATURE_FAILED.toString("Require cert in bundleInfo!"));
        } else {
            ValidateUtils.throwIfMatches(this.developmentCertificate == null, ERROR.SIGN_ERROR, SignToolErrMsg.SIGNATURE_FAILED.toString("Require cert in bundleInfo!"));
        }
    }
}

