/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.verify;

import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Collection;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;

public class VerifyUtils {
    private VerifyUtils() {
    }

    public static boolean verifyCmsSignedData(CMSSignedData cmsSignedData) throws CMSException {
        Store<X509CertificateHolder> certs = cmsSignedData.getCertificates();
        return cmsSignedData.verifySignatures(sid -> {
            try {
                Collection collection = certs.getMatches(sid);
                if (collection == null || collection.size() != 1) {
                    throw new OperatorCreationException("No matched cert or more than one matched certs: " + collection);
                }
                X509CertificateHolder cert = (X509CertificateHolder)collection.iterator().next();
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert);
            }
            catch (CertificateException e) {
                throw new OperatorCreationException("Failed to verify BC signatures: " + e.getMessage(), e);
            }
        });
    }

    static {
        Provider bc = Security.getProvider("BC");
        if (bc == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

