/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.verify;

import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import com.ohos.hapsigntool.codesigning.sign.VerifyCodeSignature;
import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.error.ProfileException;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.hap.entity.ElfBlockData;
import com.ohos.hapsigntool.hap.entity.SignHead;
import com.ohos.hapsigntool.hap.entity.SigningBlock;
import com.ohos.hapsigntool.hap.verify.HapVerify;
import com.ohos.hapsigntool.hap.verify.VerifyResult;
import com.ohos.hapsigntool.hap.verify.VerifyUtils;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class VerifyElf {
    private static final LogUtils LOGGER = new LogUtils(VerifyElf.class);

    private static String getProfileContent(byte[] profile) throws ProfileException {
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(profile);
            if (!VerifyUtils.verifyCmsSignedData(cmsSignedData)) {
                throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_INVALID.toString());
            }
            Object contentObj = cmsSignedData.getSignedContent().getContent();
            if (!(contentObj instanceof byte[])) {
                throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_FAILED.toString("Check profile failed, signed profile content is not byte array!"));
            }
            return new String((byte[])contentObj, StandardCharsets.UTF_8);
        }
        catch (CMSException e) {
            return new String(profile, StandardCharsets.UTF_8);
        }
    }

    public boolean checkParams(Options options) {
        if (!options.containsKey("outCertChain")) {
            LOGGER.error("Missing parameter: {}", "outCertChain");
            return false;
        }
        if (!options.containsKey("outProfile")) {
            LOGGER.error("Missing parameter: {}", "outProfile");
            return false;
        }
        if (!options.containsKey("outproof")) {
            LOGGER.warn("Missing parameter: {}", "outproof");
        }
        return true;
    }

    public boolean verify(Options options) {
        VerifyResult verifyResult;
        try {
            if (!this.checkParams(options)) {
                LOGGER.error("Check params failed!");
                throw new IOException();
            }
            String filePath = options.getString("inFile");
            if (StringUtils.isEmpty(filePath)) {
                LOGGER.error("Not found verify file path!");
                throw new IOException();
            }
            File signedFile = new File(filePath);
            if (!this.checkSignFile(signedFile)) {
                LOGGER.error("Check input signature ELF false!");
                throw new IOException();
            }
            verifyResult = this.verifyElf(filePath);
            if (!verifyResult.isVerified()) {
                LOGGER.error("verify: {}", verifyResult.getMessage());
                throw new IOException();
            }
            String outputCertPath = options.getString("outCertChain");
            if (verifyResult.getCertificates() != null) {
                this.writeCertificate(outputCertPath, verifyResult.getCertificates());
            }
        }
        catch (IOException e) {
            LOGGER.error("Write certificate chain error", e);
            return false;
        }
        String outputProfileFile = options.getString("outProfile");
        try {
            this.outputOptionalBlocks(outputProfileFile, verifyResult);
        }
        catch (IOException e) {
            LOGGER.error("Output optional blocks error", e);
            return false;
        }
        LOGGER.info("verify: {}", verifyResult.getMessage());
        return true;
    }

    private void writeCertificate(String destFile, List<X509Certificate> certificates) throws IOException {
        try (JcaPEMWriter writer = new JcaPEMWriter(new FileWriter(destFile));){
            for (X509Certificate cert : certificates) {
                writer.write(cert.getSubjectDN().toString() + System.lineSeparator());
                writer.writeObject(cert);
            }
            LOGGER.info("Write certificate chain success!");
        }
    }

    private void outputOptionalBlocks(String outputProfileFile, VerifyResult verifyResult) throws IOException {
        byte[] profile = verifyResult.getProfile();
        if (profile != null) {
            this.writeOptionalBytesToFile(profile, outputProfileFile);
        }
    }

    private void writeOptionalBytesToFile(byte[] data, String outputFile) throws IOException {
        if (outputFile == null || outputFile.isEmpty()) {
            return;
        }
        try (OutputStream out = Files.newOutputStream(Paths.get(outputFile, new String[0]), new OpenOption[0]);){
            out.write(data);
            out.flush();
        }
    }

    private boolean checkSignFile(File signedFile) {
        try {
            FileUtils.isValidFile(signedFile);
        }
        catch (IOException e) {
            LOGGER.error("signedFile is invalid.", e);
            return false;
        }
        return true;
    }

    public VerifyResult verifyElf(String binFile) {
        VerifyResult result = new VerifyResult(true, 10000, "verify signature success");
        File bin = new File(binFile);
        try {
            String profileJson;
            byte[] bytes = FileUtils.readFile(bin);
            ElfBlockData elfSignBlockData = this.getElfSignBlockData(bytes);
            Map<Character, SigningBlock> signBlock = this.getSignBlock(bytes, elfSignBlockData);
            if (signBlock.containsKey(Character.valueOf('\u0001'))) {
                byte[] profileByte = signBlock.get(Character.valueOf('\u0001')).getValue();
                profileJson = new String(profileByte, StandardCharsets.UTF_8);
                result.setProfile(profileByte);
                LOGGER.warn("profile is not signed");
            } else if (signBlock.containsKey(Character.valueOf('\u0002'))) {
                SigningBlock profileSign = signBlock.get(Character.valueOf('\u0002'));
                byte[] profileByte = profileSign.getValue();
                profileJson = VerifyElf.getProfileContent(profileByte);
                result = new HapVerify().verifyElfProfile(profileSign.getValue());
                result.setProfile(profileByte);
                LOGGER.info("verify profile success");
            } else {
                LOGGER.warn("can not found profile sign block");
                profileJson = null;
            }
            if (signBlock.containsKey(Character.valueOf('\u0003'))) {
                SigningBlock codesign = signBlock.get(Character.valueOf('\u0003'));
                if (!VerifyCodeSignature.verifyElf(bin, codesign.getOffset(), codesign.getLength(), "elf", profileJson)) {
                    String errMsg = "Verify codesign error!";
                    result = new VerifyResult(false, 10002, errMsg);
                }
                LOGGER.info("verify codesign success");
            } else {
                LOGGER.warn("can not found code sign block");
            }
        }
        catch (IOException e) {
            LOGGER.error("Verify file has IO error!", e);
            result = new VerifyResult(false, 10002, e.getMessage());
        }
        catch (FsVerityDigestException | VerifyCodeSignException e) {
            LOGGER.error("Verify codesign error!", e);
            result = new VerifyResult(false, 10002, e.getMessage());
        }
        catch (ProfileException | CMSException e) {
            LOGGER.error("Verify profile error!", e);
            result = new VerifyResult(false, 10002, e.getMessage());
        }
        return result;
    }

    private ElfBlockData getElfSignBlockData(byte[] bytes) throws IOException {
        int i;
        int offset = bytes.length - 32;
        byte[] magicByte = this.readByteArrayOffset(bytes, offset, SignHead.ELF_MAGIC.length);
        byte[] versionByte = this.readByteArrayOffset(bytes, offset += SignHead.ELF_MAGIC.length, SignHead.VERSION.length);
        offset += SignHead.VERSION.length;
        for (i = 0; i < SignHead.ELF_MAGIC.length; ++i) {
            if (SignHead.ELF_MAGIC[i] == magicByte[i]) continue;
            throw new IOException("elf magic verify failed");
        }
        for (i = 0; i < SignHead.VERSION.length; ++i) {
            if (SignHead.VERSION[i] == versionByte[i]) continue;
            throw new IOException("elf sign version verify failed");
        }
        int intByteLength = 4;
        byte[] blockSizeByte = this.readByteArrayOffset(bytes, offset, intByteLength);
        byte[] blockNumByte = this.readByteArrayOffset(bytes, offset += intByteLength, intByteLength);
        ByteBuffer blockNumBf = ByteBuffer.wrap(blockNumByte).order(ByteOrder.LITTLE_ENDIAN);
        int blockNum = blockNumBf.getInt();
        ByteBuffer blockSizeBf = ByteBuffer.wrap(blockSizeByte).order(ByteOrder.LITTLE_ENDIAN);
        int blockSize = blockSizeBf.getInt();
        int blockStart = bytes.length - 32 - blockSize;
        return new ElfBlockData(blockNum, blockStart);
    }

    private Map<Character, SigningBlock> getSignBlock(byte[] bytes, ElfBlockData elfBlockData) throws ProfileException {
        int offset = elfBlockData.getBlockStart();
        HashMap<Character, SigningBlock> blockMap = new HashMap<Character, SigningBlock>();
        for (int i = 0; i < elfBlockData.getBlockNum(); ++i) {
            byte[] blockByte = this.readByteArrayOffset(bytes, offset, 12);
            ByteBuffer blockBuffer = ByteBuffer.wrap(blockByte).order(ByteOrder.LITTLE_ENDIAN);
            char type = blockBuffer.getChar();
            char tag = blockBuffer.getChar();
            int length = blockBuffer.getInt();
            int blockOffset = blockBuffer.getInt();
            byte[] value = this.readByteArrayOffset(bytes, elfBlockData.getBlockStart() + blockOffset, length);
            blockMap.put(Character.valueOf(type), new SigningBlock(type, value, elfBlockData.getBlockStart() + blockOffset));
            offset += 12;
        }
        return blockMap;
    }

    private byte[] readByteArrayOffset(byte[] bytes, int offset, int length) {
        byte[] output = new byte[length];
        System.arraycopy(bytes, offset, output, 0, length);
        return output;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

