/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.verify;

import com.ohos.hapsigntool.hap.verify.VerifyUtils;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.LogUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SignatureException;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;

public class VerifyAndParseProvision {
    private static final LogUtils LOGGER = new LogUtils(VerifyAndParseProvision.class);

    public boolean verifyAndParseProvision(String signedProvisionPath, String unsignedProvisionPath) {
        File signedProvisionFile = new File(signedProvisionPath);
        try {
            if (!this.checkProvisionFile(signedProvisionFile)) {
                String errorMsg = "Check input provision file failed!";
                LOGGER.error(errorMsg);
                throw new IOException();
            }
            byte[] signedProvisionData = this.getSignedProvisionData(signedProvisionFile);
            if (signedProvisionData.length == 0) {
                LOGGER.error("read provision file failed");
                throw new IOException();
            }
            byte[] unsignedProvisionData = this.getUnsignedProvisionData(signedProvisionData);
            if (unsignedProvisionData == null) {
                LOGGER.error("get unsigned provision failed");
                throw new IOException();
            }
            return this.outputUnsignedProvisionToFile(unsignedProvisionData, unsignedProvisionPath);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean checkProvisionFile(File signedProvisionFile) {
        try {
            if (!signedProvisionFile.canRead()) {
                LOGGER.error(signedProvisionFile.getCanonicalPath() + " does not exist or can not read!");
                throw new IOException();
            }
            if (!signedProvisionFile.isFile()) {
                LOGGER.error(signedProvisionFile.getCanonicalPath() + " is not a file!");
                throw new IOException();
            }
        }
        catch (IOException e) {
            LOGGER.error("getCanonicalPath failed", e);
            return false;
        }
        return true;
    }

    private byte[] getSignedProvisionData(File signedProvisionFile) {
        byte[] signedProvisionData = new byte[]{};
        try {
            signedProvisionData = FileUtils.readFileToByteArray(signedProvisionFile);
        }
        catch (IOException e) {
            LOGGER.error("readFileToByteArray failed.", e);
        }
        return signedProvisionData;
    }

    private byte[] getUnsignedProvisionData(byte[] signedProvisionData) {
        byte[] unsignedProvisionData = null;
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(signedProvisionData);
            if (!VerifyUtils.verifyCmsSignedData(cmsSignedData)) {
                throw new SignatureException("PKCS7 cms data verify faild!");
            }
            unsignedProvisionData = (byte[])cmsSignedData.getSignedContent().getContent();
        }
        catch (SignatureException | CMSException e) {
            LOGGER.error("get unsigned provision data failed.", e);
        }
        return unsignedProvisionData;
    }

    private boolean outputUnsignedProvisionToFile(byte[] unsignedProvisionData, String unsignedProvisionPath) {
        boolean ret = false;
        try (FileOutputStream unsignedProvisionOutputStream = new FileOutputStream(new File(unsignedProvisionPath));){
            unsignedProvisionOutputStream.write(unsignedProvisionData);
            ret = true;
        }
        catch (IOException e) {
            LOGGER.error("output unsigned provision to file failed.", e);
        }
        return ret;
    }
}

