/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.sign;

import com.ohos.hapsigntool.entity.ParamConstants;
import com.ohos.hapsigntool.error.SignatureException;
import com.ohos.hapsigntool.hap.config.SignerConfig;
import com.ohos.hapsigntool.hap.entity.BlockHead;
import com.ohos.hapsigntool.hap.entity.SignContentInfo;
import com.ohos.hapsigntool.hap.entity.SignHead;
import com.ohos.hapsigntool.hap.entity.SignatureBlockTypes;
import com.ohos.hapsigntool.hap.sign.Pkcs7Generator;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.HashUtils;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.ParamProcessUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

public class SignBin {
    private static final LogUtils LOGGER = new LogUtils(SignBin.class);

    private SignBin() {
    }

    public static boolean sign(SignerConfig signerConfig, Map<String, String> signParams) {
        String profileSigned;
        String profileFile;
        String outputFile;
        String inputFile;
        String codesign = signParams.get("signCode");
        if (ParamConstants.ProfileSignFlag.ENABLE_SIGN_CODE.getSignFlag().equals(codesign)) {
            LOGGER.warn("can not sign bin with codesign");
        }
        if (!SignBin.writeBlockDataToFile(inputFile = signParams.get("inFile"), outputFile = signParams.get("outFile"), profileFile = signParams.get("profileFile"), profileSigned = signParams.get("profileSigned"))) {
            LOGGER.error("The block head data made failed.");
            ParamProcessUtil.delDir(new File(outputFile));
            return false;
        }
        LOGGER.info("The block head data made success.");
        String signAlg = signParams.get("signAlg");
        if (!SignBin.writeSignDataToOutputFile(signerConfig, outputFile, signAlg)) {
            LOGGER.error("The sign data made failed.");
            ParamProcessUtil.delDir(new File(outputFile));
            return false;
        }
        LOGGER.info("The data signed success.");
        if (SignBin.writeSignHeadDataToOutputFile(inputFile, outputFile)) {
            return true;
        }
        LOGGER.error("The sign head data made failed.");
        ParamProcessUtil.delDir(new File(outputFile));
        return false;
    }

    private static boolean writeBlockDataToFile(String inputFile, String outputFile, String profileFile, String profileSigned) {
        try {
            long binFileLen = FileUtils.getFileLen(inputFile);
            long profileDataLen = FileUtils.getFileLen(profileFile);
            if (!SignBin.checkBinAndProfileLengthIsValid(binFileLen, profileDataLen)) {
                LOGGER.error("file length is invalid, binFileLen: " + binFileLen + " profileDataLen: " + profileDataLen);
                throw new IOException();
            }
            long offset = binFileLen + (long)BlockHead.getBlockLen() + (long)BlockHead.getBlockLen();
            if (SignBin.isLongOverflowInteger(offset)) {
                LOGGER.error("The profile block head offset is overflow integer range, offset: " + offset);
                throw new IOException();
            }
            char isSigned = SignatureBlockTypes.getProfileBlockTypes(profileSigned);
            byte[] proBlockByte = BlockHead.getBlockHead(isSigned, '\u0000', (short)profileDataLen, (int)offset);
            if (SignBin.isLongOverflowInteger(offset += profileDataLen)) {
                LOGGER.error("The sign block head offset is overflow integer range, offset: " + offset);
                throw new IOException();
            }
            byte[] signBlockByte = BlockHead.getBlockHead('\u0000', '\u0000', (short)0, (int)offset);
            return SignBin.writeSignedBin(inputFile, proBlockByte, signBlockByte, profileFile, outputFile);
        }
        catch (IOException e) {
            LOGGER.error("writeBlockDataToFile failed.", e);
            return false;
        }
    }

    private static boolean writeSignedBin(String inputFile, byte[] proBlockByte, byte[] signBlockByte, String profileFile, String outputFile) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
            if (!FileUtils.writeFileToDos(inputFile, dataOutputStream)) {
                LOGGER.error("Failed to write information of input file: " + inputFile + " to outputFile: " + outputFile);
                throw new IOException();
            }
            if (!FileUtils.writeByteToDos(proBlockByte, dataOutputStream)) {
                LOGGER.error("Failed to write proBlockByte to output file: " + outputFile);
                throw new IOException();
            }
            if (!FileUtils.writeByteToDos(signBlockByte, dataOutputStream)) {
                LOGGER.error("Failed to write binBlockByte to output file: " + outputFile);
                throw new IOException();
            }
            if (!FileUtils.writeFileToDos(profileFile, dataOutputStream)) {
                LOGGER.error("Failed to write profile file: " + profileFile);
                throw new IOException();
            }
        }
        catch (IOException e) {
            LOGGER.error("writeSignedBin failed.", e);
            return false;
        }
        return true;
    }

    private static boolean checkBinAndProfileLengthIsValid(long binFileLen, long profileDataLen) {
        return binFileLen != -1L && profileDataLen != -1L && !SignBin.isLongOverflowShort(profileDataLen);
    }

    private static boolean writeSignHeadDataToOutputFile(String inputFile, String outputFile) {
        long size = FileUtils.getFileLen(outputFile) - FileUtils.getFileLen(inputFile) + 32L;
        if (SignBin.isLongOverflowInteger(size)) {
            LOGGER.error("File size is overflow integer range.");
            return false;
        }
        SignHead signHeadData = new SignHead();
        byte[] signHeadByte = signHeadData.getSignHead((int)size);
        if (signHeadByte == null || signHeadByte.length == 0) {
            LOGGER.error("Failed to get sign head data.");
            return false;
        }
        return FileUtils.writeByteToOutFile(signHeadByte, outputFile);
    }

    private static boolean writeSignDataToOutputFile(SignerConfig signerConfig, String outputFile, String signAlg) {
        String alg = ParamProcessUtil.getSignatureAlgorithm(signAlg).getContentDigestAlgorithm().getDigestAlgorithm();
        byte[] data = HashUtils.getFileDigest(outputFile, alg);
        if (data == null) {
            LOGGER.error("getFileDigest failed.");
            return false;
        }
        byte[] outputChunk = null;
        SignContentInfo contentInfo = null;
        try {
            contentInfo = new SignContentInfo();
            contentInfo.addContentHashData('\u0000', '\u0088', (short)HashUtils.getHashAlgsId(alg), data.length, data);
            byte[] dig = contentInfo.getByteContent();
            outputChunk = Pkcs7Generator.BC.generateSignedData(dig, signerConfig);
            return FileUtils.writeByteToOutFile(outputChunk, outputFile);
        }
        catch (SignatureException e) {
            LOGGER.error("Sign hap Lite failed.", e);
            return false;
        }
    }

    private static boolean isLongOverflowInteger(long num) {
        return num - (num & 0xFFFFFFFFL) != 0L;
    }

    private static boolean isLongOverflowShort(long num) {
        return num - (num & 0xFFFFL) != 0L;
    }
}

